/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.facade;

import java.util.StringTokenizer;
import org.jrebirth.af.api.facade.JRebirthEvent;
import org.jrebirth.af.api.facade.JRebirthEventType;

public final class JRebirthEventBase
implements JRebirthEvent {
    private int sequence;
    private JRebirthEventType eventType;
    private String source;
    private String target;
    private String eventData;

    public JRebirthEventBase(int sequence, JRebirthEventType eventType, String source, String target, String ... eventData) {
        this.sequence = sequence;
        this.eventType = eventType;
        this.source = source;
        this.target = target;
        if (eventData.length > 0) {
            this.eventData = eventData[0];
        }
    }

    public JRebirthEventBase(String eventSerialized) {
        this.parseString(eventSerialized);
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public JRebirthEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(JRebirthEventType eventType) {
        this.eventType = eventType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getEventData() {
        return this.eventData;
    }

    public void setEventData(String eventData) {
        this.eventData = eventData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSequence()).append("|").append(this.getEventType()).append("|").append(this.getSource()).append("|").append(this.getTarget()).append("|").append(this.getEventData()).append("|");
        return sb.toString();
    }

    private void parseString(String eventSerialized) {
        StringTokenizer st = new StringTokenizer(eventSerialized, "|");
        if (st.countTokens() >= 5) {
            this.setSequence(Integer.parseInt(st.nextToken()));
            this.setEventType(JRebirthEventType.valueOf((String)st.nextToken()));
            this.setSource(st.nextToken());
            this.setTarget(st.nextToken());
            this.setEventData(st.nextToken());
        }
    }
}

