/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jrebirth.af.api.key.UniqueKey;

public class ClassKey<R>
implements UniqueKey<R> {
    private static final long serialVersionUID = -6535088425529890897L;
    private final Class<R> classField;
    private final List<Object> optionalDatas;

    public ClassKey(Class<R> classField, Object ... optionalData) {
        this.classField = classField;
        if (optionalData.length > 0) {
            this.optionalDatas = new ArrayList<Object>();
            for (Object data : optionalData) {
                this.optionalDatas.add(data);
            }
        } else {
            this.optionalDatas = null;
        }
    }

    public String getKey() {
        return this.getClassField().getName();
    }

    public Object getValue() {
        return this.getClassField();
    }

    public String toString() {
        return this.getClassField().toString();
    }

    public int hashCode() {
        return this.getClassField().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ClassKey.class && this.getClassField().equals(((ClassKey)obj).getClassField());
    }

    public Class<R> getClassField() {
        return this.classField;
    }

    public List<Object> getOptionalData() {
        return this.optionalDatas == null ? Collections.emptyList() : this.optionalDatas;
    }
}

