/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.key;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jrebirth.af.api.key.KeyGenerator;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.key.ClassKey;
import org.jrebirth.af.core.key.KeyMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.ClassUtility;

public class MultitonKey<R>
extends ClassKey<R>
implements KeyMessages {
    private static final long serialVersionUID = -6051573419682436386L;
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(MultitonKey.class);
    private String key;
    private final List<Object> keyPartList = new ArrayList<Object>();

    public MultitonKey(Class<R> classField, Object[] keyPart, Object ... optionalData) {
        super(classField, optionalData);
        for (Object k : keyPart) {
            this.keyPartList.add(k);
        }
        this.rebuildKey();
    }

    private void rebuildKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClassField().getCanonicalName()).append('|');
        for (Object keyObject : this.keyPartList) {
            sb.append(this.buildObjectKey(keyObject)).append('|');
        }
        this.key = sb.toString();
    }

    private String buildObjectKey(Object object) {
        String objectKey = null;
        Class<?> objectClass = object.getClass();
        KeyGenerator typeGenerator = objectClass.getAnnotation(KeyGenerator.class);
        objectKey = typeGenerator == null ? this.generateAggregatedKey(object) : this.generateTypeKey(object, typeGenerator);
        if (objectKey == null) {
            objectKey = object.toString();
        }
        return objectKey;
    }

    private String generateTypeKey(Object object, KeyGenerator typeGenerator) {
        String objectKey = null;
        Method method = null;
        try {
            method = object.getClass().getMethod(typeGenerator.value(), new Class[0]);
            objectKey = (String)method.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(METHOD_NOT_FOUND, new Object[]{typeGenerator.value(), object.getClass().getSimpleName(), e});
        }
        catch (SecurityException e) {
            LOGGER.log(NO_KEY_GENERATOR_METHOD, new Object[]{typeGenerator.value(), object.getClass().getSimpleName(), e});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.log(KEY_GENERATOR_FAILURE, new Object[]{typeGenerator.value(), object.getClass().getSimpleName(), e});
        }
        return objectKey;
    }

    private String generateAggregatedKey(Object object) {
        StringBuilder sb = new StringBuilder();
        for (Method m : object.getClass().getMethods()) {
            KeyGenerator methodGenerator = m.getAnnotation(KeyGenerator.class);
            if (methodGenerator == null) continue;
            Object returnedValue = null;
            try {
                returnedValue = m.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.log(METHOD_KEY_GENERATOR_FAILURE, new Object[]{m.getName(), object.getClass().getSimpleName(), e});
            }
            if (returnedValue == null) {
                LOGGER.log(NULL_METHOD_KEY, new Object[]{m.getName(), object.getClass().getSimpleName()});
                continue;
            }
            sb.append(this.convertMethodKeyObject(methodGenerator, returnedValue));
        }
        return sb.toString().isEmpty() ? null : sb.toString();
    }

    private String convertMethodKeyObject(KeyGenerator methodGenerator, Object keyValue) {
        String res = "";
        if (keyValue instanceof String) {
            res = (String)keyValue;
        } else {
            try {
                List<Method> converterList = ClassUtility.retrieveMethodList(keyValue.getClass(), methodGenerator.value());
                Method converter = null;
                for (Method m : converterList) {
                    if (m.getParameterTypes().length != 0) continue;
                    converter = m;
                }
                if (converter == null) {
                    LOGGER.log(METHOD_NOT_FOUND, new Object[]{methodGenerator.value(), keyValue.getClass().getSimpleName()});
                } else {
                    Object localKey = converter.invoke(keyValue, new Object[0]);
                    if (localKey == null) {
                        LOGGER.log(NULL_METHOD_KEY_STRING, new Object[]{converter.getName(), keyValue.getClass().getSimpleName()});
                    } else {
                        res = localKey.toString();
                    }
                }
            }
            catch (SecurityException e) {
                LOGGER.log(NO_TOSTRING_KEY_METHOD, new Object[]{methodGenerator.value(), keyValue.getClass().getSimpleName(), e});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOGGER.log(METHOD_KEY_TOSTRING_FAILURE, new Object[]{methodGenerator.value(), keyValue.getClass().getSimpleName(), e});
            }
        }
        return res + "|";
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.toString().equals(object.toString());
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public String toString() {
        return this.getKey();
    }

    @Override
    public String getKey() {
        if (this.key == null) {
            this.rebuildKey();
        }
        return this.key;
    }

    @Override
    public Object getValue() {
        Object obj = null;
        if (this.keyPartList.size() > 1) {
            obj = this.keyPartList;
        } else if (this.keyPartList.size() == 1) {
            obj = this.keyPartList.get(0);
        }
        return obj;
    }
}

