/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.link;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.GlobalFacade;
import org.jrebirth.af.api.link.Notifier;
import org.jrebirth.af.api.link.UnprocessedWaveHandler;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.command.basic.showmodel.DisplayModelWaveBean;
import org.jrebirth.af.core.command.basic.showmodel.ShowModelCommand;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.exception.WaveException;
import org.jrebirth.af.core.facade.AbstractGlobalReady;
import org.jrebirth.af.core.key.Key;
import org.jrebirth.af.core.link.DefaultUnprocessedWaveHandler;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.link.WaveHandler;
import org.jrebirth.af.core.link.WaveSubscription;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.service.ServiceTaskBase;
import org.jrebirth.af.core.service.basic.TaskTrackerService;
import org.jrebirth.af.core.util.ParameterUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.JRebirthWaves;

public class NotifierBase
extends AbstractGlobalReady
implements Notifier,
LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(NotifierBase.class);
    private final Map<WaveType, WaveSubscription> notifierMap = new HashMap<WaveType, WaveSubscription>();
    private final UnprocessedWaveHandler unprocessedWaveHandler = (UnprocessedWaveHandler)ParameterUtility.buildCustomizableClass(JRebirthParameters.UNPROCESSED_WAVE_HANDLER, DefaultUnprocessedWaveHandler.class, "UnprocessedWaveHandler");

    public NotifierBase(GlobalFacade globalFacade) {
        super(globalFacade);
    }

    public void sendWave(Wave wave) throws JRebirthThreadException {
        wave.status(Wave.Status.Processing);
        JRebirth.checkJIT();
        try {
            switch (wave.waveGroup()) {
                case CALL_COMMAND: {
                    this.callCommand(wave);
                    break;
                }
                case RETURN_DATA: {
                    this.returnData(wave);
                    break;
                }
                case ATTACH_UI: {
                    this.displayUi(wave);
                    break;
                }
                default: {
                    this.processUndefinedWave(wave);
                    break;
                }
            }
        }
        catch (WaveException e) {
            LOGGER.error(WAVE_SENDING_ERROR, (Throwable)e);
        }
    }

    private void callCommand(Wave wave) {
        Command command;
        Command command2 = command = wave.contains(JRebirthWaves.REUSE_COMMAND) && (Boolean)wave.get(JRebirthWaves.REUSE_COMMAND) != false ? (Command)this.getGlobalFacade().getCommandFacade().retrieve(wave.componentClass(), new Object[0]) : (Command)this.getGlobalFacade().getCommandFacade().retrieve(wave.componentClass(), new Object[]{wave.getWUID()});
        if (command == null) {
            LOGGER.error(COMMAND_NOT_FOUND_ERROR, new Object[]{wave.toString()});
            if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue()) {
                this.unprocessedWaveHandler.manageUnprocessedWave(COMMAND_NOT_FOUND_MESSAGE.getText(new Object[0]), wave);
            }
        } else {
            command.run(wave);
        }
    }

    private void returnData(Wave wave) {
        Service service = (Service)this.getGlobalFacade().getServiceFacade().retrieve(wave.componentClass(), new Object[0]);
        if (service == null) {
            LOGGER.error(SERVICE_NOT_FOUND_ERROR, new Object[]{wave.toString()});
            if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue()) {
                this.unprocessedWaveHandler.manageUnprocessedWave(SERVICE_NOT_FOUND_MESSAGE.getText(new Object[0]), wave);
            }
        } else {
            ServiceTaskBase task = (ServiceTaskBase)service.returnData(wave);
            if (task != null && ((Boolean)JRebirthParameters.FOLLOW_UP_SERVICE_TASKS.get()).booleanValue()) {
                ((TaskTrackerService)this.getGlobalFacade().getServiceFacade().retrieve(TaskTrackerService.class, new Object[0])).trackTask(task);
            }
        }
    }

    private void displayUi(Wave wave) {
        if (wave.componentClass() == null) {
            LOGGER.error(MODEL_NOT_FOUND_ERROR, new Object[]{wave.toString()});
            if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue()) {
                this.unprocessedWaveHandler.manageUnprocessedWave(MODEL_NOT_FOUND_MESSAGE.getText(new Object[0]), wave);
            }
        }
        DisplayModelWaveBean displayModelWaveBean = DisplayModelWaveBean.create();
        displayModelWaveBean.showModelKey(Key.create(wave.componentClass(), new Object[0]));
        if (wave.contains(JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER)) {
            displayModelWaveBean.uniquePlaceHolder((ObjectProperty<Node>)((ObjectProperty)wave.get(JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER)));
        } else if (wave.contains(JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER)) {
            displayModelWaveBean.childrenPlaceHolder((ObservableList<Node>)((ObservableList)wave.get(JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER)));
        }
        Class showModelCommandClass = wave.contains(JRebirthWaves.SHOW_MODEL_COMMAND) ? (Class)wave.getData(JRebirthWaves.SHOW_MODEL_COMMAND).getValue() : ShowModelCommand.class;
        this.callCommand(Builders.callCommand(showModelCommandClass).waveBeanList((List)wave.getData(JRebirthWaves.EXTRA_WAVE_BEANS).getValue()).waveBean((WaveBean)displayModelWaveBean));
    }

    private void processUndefinedWave(Wave wave) throws WaveException {
        LOGGER.info(NOTIFIER_CONSUMES, new Object[]{wave.toString()});
        wave.status(Wave.Status.Consumed);
        if (this.notifierMap.containsKey(wave.waveType())) {
            WaveSubscription ws = this.notifierMap.get(wave.waveType());
            wave.setWaveHandlers(new ArrayList<WaveHandler>(ws.getWaveHandlers()));
            for (WaveHandler waveHandler : ws.getWaveHandlers()) {
                if (!waveHandler.check(wave)) continue;
                waveHandler.handle(wave);
            }
        } else {
            LOGGER.warn(NO_WAVE_LISTENER, new Object[]{wave.waveType().toString()});
            if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue()) {
                this.unprocessedWaveHandler.manageUnprocessedWave(NO_WAVE_LISTENER.getText(new Object[]{wave.waveType().toString()}), wave);
            }
        }
        LOGGER.info(NOTIFIER_HANDLES, new Object[]{wave.toString()});
        wave.status(Wave.Status.Handled);
    }

    public void listen(Component<?> linkedObject, WaveChecker waveChecker, Method method, WaveType ... waveTypes) throws JRebirthThreadException {
        JRebirth.checkJIT();
        for (WaveType waveType : waveTypes) {
            if (!this.notifierMap.containsKey(waveType)) {
                this.notifierMap.put(waveType, LoopBuilder.newSubscription(waveType));
            }
            WaveSubscription ws = this.notifierMap.get(waveType);
            boolean contains = false;
            for (int i = 0; !contains && i < ws.getWaveHandlers().size(); ++i) {
                if (!ws.getWaveHandlers().get(i).getWaveReady().equals(linkedObject)) continue;
                contains = true;
            }
            if (!ws.getWaveHandlers().isEmpty() && contains) continue;
            ws.getWaveHandlers().add(LoopBuilder.newHandler(linkedObject, waveChecker, method));
        }
    }

    public void unlisten(Component<?> linkedObject, WaveType ... waveTypes) throws JRebirthThreadException {
        JRebirth.checkJIT();
        for (WaveType waveType : waveTypes) {
            if (!this.notifierMap.containsKey(waveType)) continue;
            WaveSubscription ws = this.notifierMap.get(waveType);
            boolean removed = false;
            for (int i = ws.getWaveHandlers().size() - 1; !removed && i >= 0; --i) {
                if (!ws.getWaveHandlers().get(i).getWaveReady().equals(linkedObject)) continue;
                ws.getWaveHandlers().remove(i);
                removed = true;
            }
            if (!ws.getWaveHandlers().isEmpty()) continue;
            this.notifierMap.remove(waveType);
        }
    }

    public void unlistenAll(Component<?> linkedObject) throws JRebirthThreadException {
        JRebirth.checkJIT();
        ArrayList<WaveSubscription> toRemove = new ArrayList<WaveSubscription>();
        for (WaveSubscription ws : this.notifierMap.values()) {
            for (int i = ws.getWaveHandlers().size() - 1; i >= 0; --i) {
                WaveHandler wh = ws.getWaveHandlers().get(i);
                if (wh.getWaveReady() != linkedObject) continue;
                ws.getWaveHandlers().remove(i);
            }
            if (!ws.getWaveHandlers().isEmpty()) continue;
            toRemove.add(ws);
        }
        for (WaveSubscription ws : toRemove) {
            this.notifierMap.remove(ws.getWaveType());
        }
    }

    private static final class LoopBuilder {
        private LoopBuilder() {
        }

        public static WaveSubscription newSubscription(WaveType waveType) {
            return new WaveSubscription(waveType, new ArrayList<WaveHandler>());
        }

        public static WaveHandler newHandler(Component<?> linkedObject, WaveChecker waveChecker, Method method) {
            return new WaveHandler(linkedObject, waveChecker, method);
        }
    }
}

