/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.link;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.concurrent.RunInto;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.checker.WaveChecker;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.exception.WaveException;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.ClassUtility;

public class WaveHandler
implements LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(WaveHandler.class);
    private final Component<?> waveReady;
    private final Method defaultMethod;
    private final WaveChecker waveChecker;

    public WaveHandler(Component<?> waveReady, WaveChecker waveChecker, Method defaultMethod) {
        this.waveReady = waveReady;
        this.waveChecker = waveChecker;
        this.defaultMethod = defaultMethod;
    }

    public boolean check(Wave wave) {
        return this.waveChecker == null || (Boolean)this.waveChecker.call((Object)wave) != false;
    }

    public Component<?> getWaveReady() {
        return this.waveReady;
    }

    public void handle(Wave wave) throws WaveException {
        Method customMethod = this.retrieveCustomMethod(wave);
        if (customMethod == null) {
            throw new WaveException(wave);
        }
        RunInto runInto = customMethod.getAnnotation(RunInto.class);
        RunnablePriority priority = runInto == null ? RunnablePriority.Normal : runInto.priority();
        RunType runType = runInto == null ? null : runInto.value();
        JRebirthRunnable waveHandlerRunnable = this.buildWaveRunnable(wave, customMethod, priority);
        if (runType != null && runType == RunType.JAT || runType == null && this.getWaveReady() instanceof Model) {
            JRebirth.runIntoJAT(waveHandlerRunnable);
        } else if (runType != null && runType == RunType.JTP) {
            JRebirth.runIntoJTP(waveHandlerRunnable);
        } else {
            waveHandlerRunnable.run();
        }
    }

    private JRebirthRunnable buildWaveRunnable(final Wave wave, final Method customMethod, RunnablePriority priority) {
        final WaveHandler waveHandler = this;
        return new AbstractJrbRunnable(this.getWaveReady().getClass().getSimpleName() + " handle wave " + wave.toString(), priority){

            @Override
            protected void runInto() throws JRebirthThreadException {
                try {
                    WaveHandler.this.performHandle(wave, customMethod);
                }
                catch (WaveException e) {
                    LOGGER.error(LinkMessages.WAVE_HANDLING_ERROR, (Throwable)e);
                }
                finally {
                    wave.removeWaveHandler((Object)waveHandler);
                }
            }
        };
    }

    private Method retrieveCustomMethod(Wave wave) {
        Method customMethod = null;
        try {
            customMethod = this.defaultMethod == null ? ClassUtility.getMethodByName(this.getWaveReady().getClass(), ClassUtility.underscoreToCamelCase(wave.waveType().toString())) : this.defaultMethod;
        }
        catch (NoSuchMethodException e) {
            LOGGER.info(CUSTOM_METHOD_NOT_FOUND, new Object[]{e.getMessage(), e});
        }
        return customMethod;
    }

    private void performHandle(Wave wave, Method method) throws WaveException {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (WaveData wd : wave.waveDatas()) {
            if (!wd.getKey().isParameter()) continue;
            parameterValues.add(wd.getValue());
        }
        parameterValues.add(wave);
        if (method == null) {
            try {
                ClassUtility.getMethodByName(this.getWaveReady().getClass(), "processWave").invoke(this.getWaveReady(), wave);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.error(WAVE_DISPATCH_ERROR, (Throwable)e);
                throw new WaveException(wave, (Throwable)e);
            }
        }
        try {
            ClassUtility.callMethod(method, this.getWaveReady(), parameterValues.toArray());
        }
        catch (CoreException e) {
            LOGGER.error(WAVE_DISPATCH_ERROR, (Throwable)e);
            throw new WaveException(wave, (Throwable)e);
        }
    }
}

