/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.log;

import org.jrebirth.af.api.resource.i18n.JRLevel;
import org.jrebirth.af.api.resource.i18n.MessageItem;
import org.jrebirth.af.core.log.AbstractLogAdapter;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class LogbackAdapter
extends AbstractLogAdapter {
    public static final String FQCN = LogbackAdapter.class.getName();

    public LogbackAdapter(ch.qos.logback.classic.Logger logger) {
        super((Logger)logger);
    }

    public ch.qos.logback.classic.Logger getLogger() {
        return (ch.qos.logback.classic.Logger)super.getLogger();
    }

    private int convertLevel(JRLevel level) {
        int logbackLevel = 0;
        switch (level) {
            case Trace: {
                logbackLevel = 0;
                break;
            }
            case Debug: {
                logbackLevel = 10;
                break;
            }
            case Warn: {
                logbackLevel = 30;
                break;
            }
            case Error: {
                logbackLevel = 40;
                break;
            }
            case Info: {
                logbackLevel = 20;
                break;
            }
        }
        return logbackLevel;
    }

    public void log(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, this.convertLevel(messageItem.getLevel()), messageItem.getText(new Object[0]), null, null);
        this.throwError(messageItem, null, new Object[0]);
    }

    public void log(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, this.convertLevel(messageItem.getLevel()), messageItem.getText(new Object[0]), null, t);
        this.throwError(messageItem, t, new Object[0]);
    }

    public void log(MessageItem messageItem, Object ... parameters) {
        this.getLogger().log(messageItem.getMarker(), FQCN, this.convertLevel(messageItem.getLevel()), messageItem.getText(parameters), null, null);
        this.throwError(messageItem, null, parameters);
    }

    public void log(MessageItem messageItem, Throwable t, Object ... parameters) {
        this.getLogger().log(messageItem.getMarker(), FQCN, this.convertLevel(messageItem.getLevel()), messageItem.getText(parameters), null, t);
        this.throwError(messageItem, t, parameters);
    }

    public void trace(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 0, messageItem.getText(new Object[0]), null, null);
    }

    public void trace(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 0, messageItem.getText(new Object[0]), null, t);
    }

    public void trace(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isTraceEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 0, messageItem.getText(parameters), null, t);
        }
    }

    public void trace(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isTraceEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 0, messageItem.getText(parameters), null, null);
        }
    }

    public void debug(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 10, messageItem.getText(new Object[0]), null, null);
    }

    public void debug(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 10, messageItem.getText(new Object[0]), null, t);
    }

    public void debug(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isDebugEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 10, messageItem.getText(parameters), null, t);
        }
    }

    public void debug(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isDebugEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 10, messageItem.getText(parameters), null, null);
        }
    }

    public void info(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 20, messageItem.getText(new Object[0]), null, null);
    }

    public void info(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 20, messageItem.getText(new Object[0]), null, t);
    }

    public void info(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isInfoEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 20, messageItem.getText(parameters), null, t);
        }
    }

    public void info(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isInfoEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 20, messageItem.getText(parameters), null, null);
        }
    }

    public void warn(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 30, messageItem.getText(new Object[0]), null, null);
    }

    public void warn(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 30, messageItem.getText(new Object[0]), null, t);
    }

    public void warn(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isWarnEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 30, messageItem.getText(parameters), null, t);
        }
    }

    public void warn(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isWarnEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 30, messageItem.getText(parameters), null, null);
        }
    }

    public void error(MessageItem messageItem) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 40, messageItem.getText(new Object[0]), null, null);
        this.throwError(messageItem, null, new Object[0]);
    }

    public void error(MessageItem messageItem, Throwable t) {
        this.getLogger().log(messageItem.getMarker(), FQCN, 40, messageItem.getText(new Object[0]), null, t);
        this.throwError(messageItem, t, new Object[0]);
    }

    public void error(MessageItem messageItem, Throwable t, Object ... parameters) {
        if (this.getLogger().isErrorEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 40, messageItem.getText(parameters), null, t);
        }
        this.throwError(messageItem, t, parameters);
    }

    public void error(MessageItem messageItem, Object ... parameters) {
        if (this.getLogger().isErrorEnabled(messageItem.getMarker())) {
            this.getLogger().log(messageItem.getMarker(), FQCN, 40, messageItem.getText(parameters), null, null);
        }
        this.throwError(messageItem, null, parameters);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.getLogger().isDebugEnabled(marker);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isErrorEnabled();
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.getLogger().isErrorEnabled(marker);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isInfoEnabled();
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.getLogger().isInfoEnabled(marker);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.getLogger().isTraceEnabled(marker);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isWarnEnabled();
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.getLogger().isWarnEnabled(marker);
    }
}

