/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource;

import java.lang.reflect.Field;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jrebirth.af.api.resource.ResourceParams;
import org.jrebirth.af.core.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseParams
implements ResourceParams {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseParams.class);
    private boolean changed;
    private String key;

    public AbstractBaseParams() {
        this.hasChanged(true);
    }

    public void activateAutoRefresh() {
        ChangeListener<Object> changeListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> value, Object oldValue, Object newValue) {
                if (ObjectUtility.notEquals(oldValue, newValue)) {
                    LOGGER.trace(value.toString() + " has changed");
                    AbstractBaseParams.this.hasChanged(true);
                }
            }
        };
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!Property.class.isAssignableFrom(field.getDeclaringClass())) continue;
            try {
                ((Property)field.get(this)).addListener((ChangeListener)changeListener);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error("Cannot access to property " + field.getName() + " of class " + this.getClass(), (Throwable)e);
            }
        }
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void hasChanged(boolean changed) {
        this.changed = changed;
    }

    public String getKey() {
        if (this.hasChanged()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getFieldValues().size(); ++i) {
                sb.append(this.getFieldValues().get(i).toString());
                if (i >= this.getFieldValues().size() - 1) continue;
                sb.append("\\|\\|");
            }
            this.setKey(sb.toString());
        }
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.hasChanged(false);
    }

    protected double readDouble(String doubleString, double min, double max) {
        return Math.max(Math.min(Double.parseDouble(doubleString), max), min);
    }

    protected int readInteger(String intString, int min, int max) {
        return Math.max(Math.min(Integer.parseInt(intString), max), min);
    }

    protected boolean readBoolean(String parameter) {
        return parameter != null && "true".equalsIgnoreCase(parameter) || "yes".equalsIgnoreCase(parameter) || "1".equalsIgnoreCase(parameter);
    }

    public String toString() {
        return this.getKey();
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object params) {
        return params == null || !(params instanceof AbstractBaseParams) ? false : this.getKey().equals(((AbstractBaseParams)params).getKey());
    }

    protected abstract List<? extends Object> getFieldValues();
}

