/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import javafx.scene.paint.Color;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.color.ColorItem;
import org.jrebirth.af.api.resource.color.ColorParams;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.color.GrayColor;
import org.jrebirth.af.core.resource.color.HSBColor;
import org.jrebirth.af.core.resource.color.RGB01Color;
import org.jrebirth.af.core.resource.color.RGB255Color;
import org.jrebirth.af.core.resource.color.WebColor;

public interface ColorItemReal
extends ColorItem {
    default public ResourceBuilder<ColorItem, ColorParams, Color> builder() {
        return ResourceBuilders.COLOR_BUILDER;
    }

    public static interface Gray
    extends ColorItemReal {
        default public void gray(double gray, double opacity) {
            this.set(new GrayColor(gray, opacity));
        }

        default public void gray(double gray) {
            this.set(new GrayColor(gray));
        }
    }

    public static interface HSB
    extends ColorItemReal {
        default public void hsb(double hue, double saturation, double brightness, double opacity) {
            this.set(new HSBColor(hue, saturation, brightness, opacity));
        }

        default public void hsb(double hue, double saturation, double brightness) {
            this.set(new HSBColor(hue, saturation, brightness));
        }
    }

    public static interface RGB01
    extends ColorItemReal {
        default public void rgb(double red, double green, double blue, double opacity) {
            this.set(new RGB01Color(red, green, blue, opacity));
        }

        default public void rgb(double red, double green, double blue) {
            this.set(new RGB01Color(red, green, blue));
        }
    }

    public static interface RGB255
    extends ColorItemReal {
        default public void rgb255(int red, int green, int blue, double opacity) {
            this.set(new RGB255Color(red, green, blue, opacity));
        }

        default public void rgb255(int red, int green, int blue) {
            this.set(new RGB255Color(red, green, blue));
        }
    }

    public static interface Web
    extends ColorItemReal {
        default public void web(String hex, double opacity) {
            this.set(new WebColor(hex, opacity));
        }

        default public void web(String hex) {
            this.set(new WebColor(hex));
        }
    }
}

