/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import org.jrebirth.af.core.resource.color.AbstractBaseColor;

public class HSBColor
extends AbstractBaseColor {
    private final DoubleProperty hue = new SimpleDoubleProperty();
    private final DoubleProperty saturation = new SimpleDoubleProperty();
    private final DoubleProperty brightness = new SimpleDoubleProperty();

    public HSBColor(double hue, double saturation, double brightness) {
        this.hue.set(hue);
        this.saturation.set(saturation);
        this.brightness.set(brightness);
    }

    public HSBColor(double hue, double saturation, double brightness, double opacity) {
        super(opacity);
        this.hue.set(hue);
        this.saturation.set(saturation);
        this.brightness.set(brightness);
    }

    public double hue() {
        return this.hue.get();
    }

    public DoubleProperty hueProperty() {
        return this.hue;
    }

    public double saturation() {
        return this.saturation.get();
    }

    public DoubleProperty saturationProperty() {
        return this.saturation;
    }

    public double brightness() {
        return this.brightness.get();
    }

    public DoubleProperty brightnessProperty() {
        return this.brightness;
    }

    public void parse(String ... parameters) {
        if (parameters.length >= 1) {
            this.hueProperty().set(this.readDouble(parameters[0], 0.0, 360.0));
        }
        if (parameters.length >= 2) {
            this.saturationProperty().set(this.readDouble(parameters[1], 0.0, 1.0));
        }
        if (parameters.length >= 3) {
            this.brightnessProperty().set(this.readDouble(parameters[2], 0.0, 1.0));
        }
        if (parameters.length >= 4) {
            this.opacityProperty().set(this.readDouble(parameters[3], 0.0, 1.0));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.hue(), this.saturation(), this.brightness(), this.opacity());
    }
}

