/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.color;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.jrebirth.af.core.resource.color.AbstractBaseColor;

public final class RGB255Color
extends AbstractBaseColor {
    private final IntegerProperty redProperty = new SimpleIntegerProperty();
    private final IntegerProperty greenProperty = new SimpleIntegerProperty();
    private final IntegerProperty blueProperty = new SimpleIntegerProperty();

    public RGB255Color(int red, int green, int blue) {
        this.redProperty.set(red);
        this.greenProperty.set(green);
        this.blueProperty.set(blue);
    }

    public RGB255Color(int red, int green, int blue, double opacity) {
        super(opacity);
        this.redProperty.set(red);
        this.greenProperty.set(green);
        this.blueProperty.set(blue);
    }

    public int red() {
        return this.redProperty.get();
    }

    public IntegerProperty redProperty() {
        return this.redProperty;
    }

    public int green() {
        return this.greenProperty.get();
    }

    public IntegerProperty greenProperty() {
        return this.greenProperty;
    }

    public int blue() {
        return this.blueProperty.get();
    }

    public IntegerProperty blueProperty() {
        return this.blueProperty;
    }

    public void parse(String ... parameters) {
        if (parameters.length >= 1) {
            this.redProperty().set(this.readInteger(parameters[0], 0, 255));
        }
        if (parameters.length >= 2) {
            this.greenProperty().set(this.readInteger(parameters[1], 0, 255));
        }
        if (parameters.length >= 3) {
            this.blueProperty().set(this.readInteger(parameters[2], 0, 255));
        }
        if (parameters.length >= 4) {
            this.opacityProperty().set(this.readDouble(parameters[3], 0.0, 1.0));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.red(), this.green(), this.blue(), this.opacity());
    }
}

