/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.font;

import java.util.Arrays;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jrebirth.af.api.resource.font.FontExtension;
import org.jrebirth.af.core.resource.font.AbstractBaseFont;

public class FamilyFont
extends AbstractBaseFont {
    private final transient StringProperty familyProperty = new SimpleStringProperty();
    private final transient ObjectProperty<FontPosture> postureProperty = new SimpleObjectProperty();
    private final transient ObjectProperty<FontWeight> weightProperty = new SimpleObjectProperty();

    public FamilyFont(String family, double size, FontExtension extension) {
        this(family, size, extension, FontWeight.NORMAL, FontPosture.REGULAR);
    }

    public FamilyFont(String family, double size) {
        this(family, size, FontWeight.NORMAL, FontPosture.REGULAR);
    }

    public FamilyFont(String family, double size, FontExtension extension, FontWeight weight) {
        this(family, size, extension, weight, FontPosture.REGULAR);
    }

    public FamilyFont(String family, double size, FontWeight weight) {
        this(family, size, weight, FontPosture.REGULAR);
    }

    public FamilyFont(String family, double size, FontExtension extension, FontPosture posture) {
        this(family, size, extension, FontWeight.NORMAL, posture);
    }

    public FamilyFont(String family, double size, FontPosture posture) {
        this(family, size, FontWeight.NORMAL, posture);
    }

    public FamilyFont(String family, double size, FontExtension extension, FontWeight weight, FontPosture posture) {
        super(null, size, extension);
        this.familyProperty.set((Object)family);
        this.weightProperty.set((Object)weight);
        this.postureProperty.set((Object)posture);
    }

    public FamilyFont(String family, double size, FontWeight weight, FontPosture posture) {
        super(null, size);
        this.familyProperty.set((Object)family);
        this.weightProperty.set((Object)weight);
        this.postureProperty.set((Object)posture);
    }

    public String family() {
        return (String)this.familyProperty.get();
    }

    public StringProperty familyProperty() {
        return this.familyProperty;
    }

    public FontPosture posture() {
        return (FontPosture)this.postureProperty.get();
    }

    public ObjectProperty<FontPosture> postureProperty() {
        return this.postureProperty;
    }

    public FontWeight weight() {
        return (FontWeight)this.weightProperty.get();
    }

    public ObjectProperty<FontWeight> weightProperty() {
        return this.weightProperty;
    }

    public void parse(String ... parameters) {
        if (parameters.length >= 1) {
            this.familyProperty().set((Object)parameters[0]);
        }
        if (parameters.length >= 2) {
            this.sizeProperty().set(Double.parseDouble(parameters[1]));
        }
        if (parameters.length >= 3) {
            this.weightProperty().set((Object)FontWeight.findByName((String)parameters[2]));
        }
        if (parameters.length >= 4) {
            this.postureProperty().set((Object)FontPosture.findByName((String)parameters[3]));
        }
    }

    @Override
    protected List<? extends Object> getFieldValues() {
        return Arrays.asList(this.family(), this.size(), this.weight().toString(), this.posture().toString());
    }
}

