/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.font;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.font.FontItem;
import org.jrebirth.af.api.resource.font.FontParams;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.font.FamilyFont;
import org.jrebirth.af.core.resource.font.RealFont;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FontBuilder
extends AbstractResourceBuilder<FontItem, FontParams, Font>
implements ResourceBuilder<FontItem, FontParams, Font> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontBuilder.class);

    @Override
    protected Font buildResource(FontItem fontItem, FontParams jrFont) {
        Font font = null;
        font = jrFont instanceof RealFont ? this.buildRealFont((RealFont)jrFont) : (jrFont instanceof FamilyFont ? this.buildFamilyFont((FamilyFont)jrFont) : Font.getDefault());
        return font;
    }

    private Font buildRealFont(RealFont rFont) {
        this.checkFontStatus(rFont);
        return javafx.scene.text.FontBuilder.create().name(this.transformFontName(rFont.name().name())).size(rFont.size()).build();
    }

    private Font buildFamilyFont(FamilyFont familyFont) {
        Font font = null;
        font = familyFont.posture() == null && familyFont.weight() == null ? Font.font((String)this.transformFontName(familyFont.family()), (double)familyFont.size()) : (familyFont.posture() == null ? Font.font((String)this.transformFontName(familyFont.family()), (FontWeight)familyFont.weight(), (double)familyFont.size()) : (familyFont.weight() == null ? Font.font((String)this.transformFontName(familyFont.family()), (FontPosture)familyFont.posture(), (double)familyFont.size()) : Font.font((String)this.transformFontName(familyFont.family()), (FontWeight)familyFont.weight(), (FontPosture)familyFont.posture(), (double)familyFont.size())));
        return font;
    }

    private String transformFontName(String fontName) {
        return fontName.replace("_", " ");
    }

    private void checkFontStatus(FontParams fontParams) {
        List fonts = Font.getFontNames((String)this.transformFontName(fontParams.name().name()));
        Font font = null;
        String fontName = null;
        if (fonts.isEmpty()) {
            List<String> fontPaths = fontParams instanceof RealFont && ((RealFont)fontParams).skipFontsFolder() ? Collections.singletonList("") : (List<String>)JRebirthParameters.FONT_FOLDER.get();
            for (int i = 0; i < fontPaths.size() && font == null; ++i) {
                String fontPath = fontPaths.get(i);
                if (!fontPath.isEmpty()) {
                    fontPath = fontPath + "/";
                }
                fontName = fontPath + this.transformFontName(fontParams.name().name()) + "." + fontParams.extension();
                LOGGER.trace("Try to load Transformed Font  {}", (Object)fontName);
                font = Font.loadFont((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(fontName), (double)fontParams.size());
                if (font == null) {
                    fontName = fontPath + fontParams.name().name() + "." + fontParams.extension();
                    LOGGER.trace("Try to load Raw Font  {}", (Object)fontName);
                    font = Font.loadFont((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(fontName), (double)fontParams.size());
                    if (font == null) continue;
                    LOGGER.info("{} Raw Font loaded", (Object)fontName);
                    continue;
                }
                LOGGER.info("{} Transformed Font loaded", (Object)fontName);
            }
            if (font == null) {
                LOGGER.error("Font : {} not found into base folder: {}", (Object)(fontParams.name().name() + "." + fontParams.extension()), JRebirthParameters.FONT_FOLDER.get());
            }
        }
    }
}

