/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.i18n;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.i18n.MessageItem;
import org.jrebirth.af.api.resource.i18n.MessageParams;
import org.jrebirth.af.api.resource.i18n.MessageResource;
import org.jrebirth.af.core.log.JRebirthMarkers;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.i18n.LogMessageParams;
import org.jrebirth.af.core.resource.i18n.MessageResourceBase;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.util.ClasspathUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageBuilder
extends AbstractResourceBuilder<MessageItem, MessageParams, MessageResource>
implements ResourceBuilder<MessageItem, MessageParams, MessageResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageBuilder.class);
    private final List<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
    private final Map<MessageItem, MessageResource> overriddenMessageMap = new ConcurrentHashMap<MessageItem, MessageResource>();
    private String messageFileWildcard;

    public void searchMessagesFiles(String wildcard) {
        this.messageFileWildcard = wildcard;
        this.readPropertiesFiles();
    }

    private void readPropertiesFiles() {
        if (this.messageFileWildcard.isEmpty() || !((Boolean)JRebirthParameters.LOG_RESOLUTION.get()).booleanValue()) {
            LOGGER.info(JRebirthMarkers.MESSAGE, "Messages Loading is skipped");
        } else {
            Pattern filePattern = Pattern.compile(this.messageFileWildcard + "\\.properties");
            Collection<String> list = ClasspathUtility.getClasspathResources(filePattern);
            LOGGER.info(JRebirthMarkers.MESSAGE, "{} Messages file{} found.", (Object)list.size(), (Object)(list.size() > 1 ? "s" : ""));
            for (String rbFilename : list) {
                this.readPropertiesFile(rbFilename);
            }
        }
    }

    private void readPropertiesFile(String rbFilename) {
        File rbFile = new File(rbFilename);
        String rbName = rbFile.getName().substring(0, rbFile.getName().lastIndexOf(".properties"));
        if (rbName == null || rbName.isEmpty()) {
            LOGGER.error(JRebirthMarkers.MESSAGE, "Resource Bundle must be not null and not empty");
        } else {
            LOGGER.info(JRebirthMarkers.MESSAGE, "Store ResourceBundle : {} ", (Object)rbName);
            try {
                this.resourceBundles.add(ResourceBundle.getBundle(rbName));
            }
            catch (MissingResourceException e) {
                LOGGER.error(JRebirthMarkers.MESSAGE, "{} Resource Bundle not found", (Object)rbName);
            }
        }
    }

    @Override
    protected MessageResource buildResource(MessageItem messageItem, MessageParams messageParams) {
        MessageResource messageResource = null;
        if (messageParams.name() != null && this.overriddenMessageMap.containsKey(messageItem)) {
            messageResource = this.overriddenMessageMap.get(messageItem);
        }
        if (messageResource == null && messageParams.name() != null) {
            String rawMessage;
            boolean translationAllowed = !(messageParams instanceof LogMessageParams) || (Boolean)JRebirthParameters.LOG_RESOLUTION.get() != false;
            String string = rawMessage = translationAllowed ? this.findMessage(messageParams.name()) : null;
            if (rawMessage == null) {
                rawMessage = '<' + messageParams.name() + '>';
            }
            messageResource = messageParams instanceof LogMessageParams ? new MessageResourceBase(rawMessage, ((LogMessageParams)messageParams).marker(), ((LogMessageParams)messageParams).level()) : new MessageResourceBase(rawMessage);
        }
        return messageResource;
    }

    private String findMessage(String messageKey) {
        String message = null;
        try {
            if (!this.resourceBundles.isEmpty()) {
                for (int i = this.resourceBundles.size() - 1; i >= 0 && message == null; --i) {
                    if (!this.resourceBundles.get(i).containsKey(messageKey)) continue;
                    message = this.resourceBundles.get(i).getString(messageKey);
                }
            }
        }
        catch (MissingResourceException e) {
            LOGGER.error("Message key not found into resource bundle", (Throwable)e);
        }
        return message;
    }

    public void define(MessageItem key, MessageResource forcedValue) {
        this.overriddenMessageMap.put(key, forcedValue);
        this.set(this.getParamKey(key), forcedValue);
    }
}

