/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.image;

import javafx.scene.image.Image;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.image.ImageExtension;
import org.jrebirth.af.api.resource.image.ImageItem;
import org.jrebirth.af.api.resource.image.ImageParams;
import org.jrebirth.af.core.resource.ResourceBuilders;
import org.jrebirth.af.core.resource.image.AbsImage;
import org.jrebirth.af.core.resource.image.RelImage;
import org.jrebirth.af.core.resource.image.WebImage;

public interface ImageItemReal
extends ImageItem {
    default public ResourceBuilder<ImageItem, ImageParams, Image> builder() {
        return ResourceBuilders.IMAGE_BUILDER;
    }

    public static interface Absolute
    extends ImageItemReal {
        default public void abs(String path, String name, ImageExtension extension) {
            this.set(new AbsImage(path, name, extension));
        }

        default public void abs(String name, ImageExtension extension) {
            this.set(new AbsImage(name, extension));
        }

        default public void abs(String fullName) {
            this.set(new AbsImage(fullName));
        }
    }

    public static interface Relative
    extends ImageItemReal {
        default public void rel(String path, String name, ImageExtension extension) {
            this.set(new RelImage(path, name, extension));
        }

        default public void rel(String name, ImageExtension extension) {
            this.set(new RelImage(name, extension));
        }

        default public void rel(String fullName) {
            this.set(new RelImage(fullName));
        }
    }

    public static interface Web
    extends ImageItemReal {
        default public void web(String website, String path, String name, ImageExtension extension) {
            this.set(new WebImage(website, path, name, extension));
        }

        default public void web(String website, boolean secured, String path, String name, ImageExtension extension) {
            this.set(new WebImage(website, secured, path, name, extension));
        }
    }
}

