/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.resource.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.resource.builder.ResourceBuilder;
import org.jrebirth.af.api.resource.parameter.ParameterItem;
import org.jrebirth.af.api.resource.parameter.ParameterParams;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.ParameterEntry;
import org.jrebirth.af.core.resource.builder.AbstractResourceBuilder;
import org.jrebirth.af.core.resource.parameter.ObjectParameter;
import org.jrebirth.af.core.resource.parameter.ParameterMessages;
import org.jrebirth.af.core.util.ClasspathUtility;

public final class ParameterBuilder
extends AbstractResourceBuilder<ParameterItem<?>, ParameterParams, Object>
implements ResourceBuilder<ParameterItem<?>, ParameterParams, Object>,
ParameterMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ParameterBuilder.class);
    private static final Pattern ENV_VAR_PATTERN1 = Pattern.compile("(.*)\\$\\{(\\w+)\\}(.*)");
    private static final Pattern ENV_VAR_PATTERN2 = Pattern.compile("(.*)\\$(\\w+)(.*)");
    private final Map<String, ParameterEntry> propertiesParametersMap = new ConcurrentHashMap<String, ParameterEntry>();
    private final Map<ParameterItem<?>, Object> overriddenParametersMap = new ConcurrentHashMap();
    private final Map<String, String> varenvMap = new HashMap<String, String>();
    private String configurationFileExtension;
    private String configurationFileWildcard;

    public void searchConfigurationFiles(String wildcard, String extension) {
        this.configurationFileWildcard = wildcard;
        this.configurationFileExtension = extension;
        this.readPropertiesFiles();
    }

    private void readPropertiesFiles() {
        if (this.configurationFileWildcard.isEmpty() || this.configurationFileExtension.isEmpty()) {
            LOGGER.log(SKIP_CONF_LOADING);
        } else {
            Pattern filePattern = Pattern.compile(this.configurationFileWildcard + "\\." + this.configurationFileExtension);
            Collection<String> list = ClasspathUtility.getClasspathResources(filePattern);
            LOGGER.log(CONFIG_FOUND, new Object[]{list.size(), list.size() > 1 ? "s" : ""});
            for (String confFilename : list) {
                this.readPropertiesFile(confFilename);
            }
        }
    }

    private void readPropertiesFile(String custConfFileName) {
        Properties p = new Properties();
        LOGGER.log(READ_CONF_FILE, new Object[]{custConfFileName});
        try (InputStream is = ClasspathUtility.loadInputStream(custConfFileName);){
            p.load(is);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                if (this.propertiesParametersMap.containsKey(entry.getKey())) {
                    LOGGER.log(UPDATE_PARAMETER, new Object[]{entry.getKey(), entry.getValue()});
                } else {
                    LOGGER.log(STORE_PARAMETER, new Object[]{entry.getKey(), entry.getValue()});
                }
                this.storePropertiesParameter(entry);
            }
        }
        catch (IOException e) {
            LOGGER.error(CONF_READING_ERROR, new Object[]{custConfFileName});
        }
    }

    private void storePropertiesParameter(Map.Entry<Object, Object> entry) {
        this.propertiesParametersMap.put(entry.getKey().toString(), new ParameterEntry(entry.getValue().toString()));
    }

    private String resolveVarEnv(String entryValue) {
        String value = entryValue;
        if (value != null) {
            value = this.checkPattern(value, ENV_VAR_PATTERN1, true);
            value = this.checkPattern(value, ENV_VAR_PATTERN2, false);
        }
        return value;
    }

    private String checkPattern(String value, Pattern pattern, boolean withBrace) {
        String res = value;
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String envName = matcher.group(2);
            if (!this.varenvMap.containsKey(envName)) {
                String envValue = System.getenv(envName);
                this.varenvMap.put(envName, envValue);
            }
            if (this.varenvMap.get(envName) != null) {
                if (withBrace) {
                    res = res.replace("${" + envName + "}", this.varenvMap.get(envName));
                    continue;
                }
                res = res.replace("$" + envName, this.varenvMap.get(envName));
                continue;
            }
            LOGGER.log(UNDEFINED_ENV_VAR, new Object[]{envName});
        }
        return res;
    }

    @Override
    protected Object buildResource(ParameterItem<?> parameterItem, ParameterParams parameterParams) {
        Object object = null;
        if (parameterParams instanceof ObjectParameter) {
            ObjectParameter op = (ObjectParameter)parameterParams;
            if (op.name() != null && this.overriddenParametersMap.containsKey(parameterItem)) {
                object = this.overriddenParametersMap.get(parameterItem);
            }
            if (object == null && op.name() != null && this.propertiesParametersMap.containsKey(op.name())) {
                object = op.parseObject(this.propertiesParametersMap.get(op.name()));
            }
            if (object == null) {
                object = op.object();
            }
            if (object instanceof String) {
                object = this.resolveVarEnv((String)object);
            }
        }
        return object;
    }

    public void define(ParameterItem<?> key, Object forcedValue) {
        this.overriddenParametersMap.put(key, forcedValue);
        this.set(this.getParamKey(key), forcedValue);
    }
}

