/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.control.ProgressBar;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.JRebirthThreadException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.service.ServiceTask;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.AbstractJrbRunnable;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.concurrent.JrbReferenceRunnable;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.service.ServiceMessages;
import org.jrebirth.af.core.service.ServiceTaskBase;
import org.jrebirth.af.core.service.ServiceTaskWaveListener;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.JRebirthWaves;

public abstract class AbstractService
extends AbstractBehavioredComponent<Service>
implements Service,
ServiceMessages {
    private static final String RATIO_SEPARATOR = " / ";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractService.class);
    private final ObservableMap<String, ServiceTask<?>> pendingTasks = FXCollections.observableMap(new HashMap());

    @Override
    public final void ready() throws CoreException {
        this.initService();
    }

    protected abstract void initService();

    protected void finalize() throws Throwable {
        this.getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.DESTROY_SERVICE, null, this.getClass(), new String[0]);
        super.finalize();
    }

    public <T> ServiceTask<T> returnData(Wave sourceWave) {
        ServiceTask<T> task = null;
        try {
            Method method;
            ArrayList<Object> parameterValues = new ArrayList<Object>();
            for (WaveData wd : sourceWave.waveDatas()) {
                if (!wd.getKey().isParameter()) continue;
                parameterValues.add(wd.getValue());
            }
            if (sourceWave.waveType() == null) {
                LOGGER.error(NO_WAVE_TYPE_DEFINED, new Object[]{this.getClass().getSimpleName()});
            }
            if ((method = ClassUtility.getMethodByName(this.getClass(), ClassUtility.underscoreToCamelCase(sourceWave.waveType().toString()))) != null) {
                task = this.runTask(sourceWave, method, parameterValues.toArray());
            }
        }
        catch (NoSuchMethodException e) {
            this.processWave(sourceWave);
        }
        return task;
    }

    private <T> ServiceTask<T> runTask(Wave sourceWave, Method method, Object[] parameterValues) {
        sourceWave.addWaveListener((WaveListener)new ServiceTaskWaveListener());
        ServiceTaskBase task = new ServiceTaskBase(this, method, parameterValues, sourceWave);
        this.pendingTasks.put((Object)sourceWave.getWUID(), task);
        sourceWave.addDatas(new WaveData[]{Builders.waveData(JRebirthWaves.SERVICE_TASK, task)});
        if (sourceWave.containsNotNull(JRebirthWaves.PROGRESS_BAR)) {
            this.bindProgressBar(task, (ProgressBar)sourceWave.getData(JRebirthWaves.PROGRESS_BAR).getValue());
        }
        if (sourceWave.containsNotNull(JRebirthWaves.TASK_TITLE)) {
            this.bindTitle(task, (StringProperty)sourceWave.getData(JRebirthWaves.TASK_TITLE).getValue());
        }
        if (sourceWave.containsNotNull(JRebirthWaves.TASK_MESSAGE)) {
            this.bindMessage(task, (StringProperty)sourceWave.getData(JRebirthWaves.TASK_MESSAGE).getValue());
        }
        JRebirth.runIntoJTP(task);
        return task;
    }

    private void bindProgressBar(final ServiceTaskBase<?> task, final ProgressBar progressBar) {
        JRebirth.runIntoJAT(new AbstractJrbRunnable("Bind ProgressBar to " + task.getServiceHandlerName()){

            @Override
            protected void runInto() throws JRebirthThreadException {
                task.updateProgress(0L, 0L);
                progressBar.progressProperty().bind((ObservableValue)task.workDoneProperty().divide((ObservableNumberValue)task.totalWorkProperty()));
            }
        });
    }

    private void bindTitle(final ServiceTask<?> task, final StringProperty titleProperty) {
        JRebirth.runIntoJAT(new AbstractJrbRunnable("Bind Title for " + task.getServiceHandlerName()){

            @Override
            protected void runInto() throws JRebirthThreadException {
                titleProperty.bind((ObservableValue)task.titleProperty());
            }
        });
    }

    private void bindMessage(final ServiceTask<?> task, final StringProperty messageProperty) {
        JRebirth.runIntoJAT(new AbstractJrbRunnable("Bind Message for " + task.getServiceHandlerName()){

            @Override
            protected void runInto() throws JRebirthThreadException {
                messageProperty.bind((ObservableValue)task.messageProperty());
            }
        });
    }

    public ObservableMap<String, ServiceTask<?>> pendingTasksProperty() {
        return this.pendingTasks;
    }

    public Collection<ServiceTask<?>> getPendingTaskList() {
        return this.pendingTasks.values();
    }

    public void removePendingTask(String taskKey) {
        this.pendingTasks.remove((Object)taskKey);
    }

    public ServiceTask<?> getPendingTask(String taskKey) {
        return (ServiceTask)this.pendingTasks.get((Object)taskKey);
    }

    public void updateProgress(Wave wave, long workDone, long totalWork) {
        this.updateProgress(wave, workDone, totalWork, 1.0);
    }

    public void updateProgress(final Wave wave, final long workDone, final long totalWork, double progressIncrement) {
        if (((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).checkProgressRatio(workDone, totalWork, progressIncrement)) {
            JRebirth.runIntoJAT(new AbstractJrbRunnable("ServiceTask Workdone (lng) " + workDone + RATIO_SEPARATOR + totalWork + "[" + workDone * 100L / totalWork + "%]"){

                @Override
                protected void runInto() throws JRebirthThreadException {
                    ((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).updateProgress(workDone, totalWork);
                }
            });
        }
    }

    public void updateProgress(Wave wave, double workDone, double totalWork) {
        this.updateProgress(wave, workDone, totalWork, 1.0);
    }

    public void updateProgress(Wave wave, double workDone, double totalWork, double progressIncrement) {
        if (((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).checkProgressRatio(workDone, totalWork, progressIncrement)) {
            JRebirth.runIntoJAT(new JrbReferenceRunnable("ServiceTask Workdone (dbl) " + workDone + RATIO_SEPARATOR + totalWork, () -> ((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).updateProgress(workDone, totalWork)));
        }
    }

    public void updateMessage(Wave wave, String message) {
        JRebirth.runIntoJAT(new JrbReferenceRunnable("Service Task Mesage => " + message, () -> ((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).updateMessage(message)));
    }

    public void updateTitle(Wave wave, String title) {
        JRebirth.runIntoJAT(new JrbReferenceRunnable("Service Task Title => " + title, () -> ((ServiceTaskBase)wave.get(JRebirthWaves.SERVICE_TASK)).updateTitle(title)));
    }
}

