/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import javafx.concurrent.Task;
import org.jrebirth.af.api.concurrent.JRebirthRunnable;
import org.jrebirth.af.api.concurrent.Priority;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.service.ServiceTask;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.exception.ServiceException;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.service.ServiceMessages;
import org.jrebirth.af.core.service.ServiceTaskReturnWaveListener;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.JRebirthItems;
import org.jrebirth.af.core.wave.JRebirthWaves;
import org.jrebirth.af.core.wave.WaveItemBase;

public final class ServiceTaskBase<T>
extends Task<T>
implements JRebirthRunnable,
ServiceTask<T>,
ServiceMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ServiceTaskBase.class);
    private final Object[] parameterValues;
    private final Method method;
    private final Service service;
    private final Wave wave;
    private double localWorkDone;
    private final RunnablePriority priority;
    private final Instant creationTime = Instant.now();

    ServiceTaskBase(Service service, Method method, Object[] parameterValues, Wave wave) {
        this.service = service;
        this.method = method;
        this.parameterValues = (Object[])parameterValues.clone();
        this.wave = wave;
        Priority priorityA = method.getAnnotation(Priority.class);
        this.priority = priorityA == null ? RunnablePriority.Low : priorityA.value();
    }

    public String getServiceHandlerName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.service.getClass().getSimpleName()).append(".");
        sb.append(this.method.getName()).append("(");
        for (Class<?> parameterType : this.method.getParameterTypes()) {
            sb.append(parameterType.getSimpleName()).append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    protected T call() throws CoreException {
        this.wave.status(Wave.Status.Consumed);
        Object res = null;
        try {
            ArrayList<Object> params = new ArrayList<Object>();
            for (Object o : this.parameterValues) {
                params.add(o);
            }
            params.add(this.wave);
            res = this.method.invoke((Object)this.service, params.toArray());
            if (Void.TYPE.equals(this.method.getReturnType()) && this.wave.waveType().returnItem() != JRebirthItems.voidItem) {
                LOGGER.log(NO_RETURN_WAVE_CONSUMED, new Object[]{this.service.getClass().getSimpleName(), this.wave.toString()});
                this.wave.status(Wave.Status.Handled);
            } else {
                this.sendReturnWave(res);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.log(SERVICE_TASK_ERROR, (Throwable)e, new Object[]{this.getServiceHandlerName()});
            this.wave.status(Wave.Status.Failed);
        }
        catch (ServiceException se) {
            LOGGER.log(SERVICE_TASK_EXCEPTION, (Throwable)se, new Object[]{se.getExplanation(), this.getServiceHandlerName()});
            this.wave.status(Wave.Status.Failed);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return (T)res;
    }

    private void handleException(Exception e) {
        this.wave.status(Wave.Status.Failed);
        Wave exceptionHandlerWave = (Wave)this.wave.waveType().waveExceptionHanler().get(e.getClass());
        if (exceptionHandlerWave != null) {
            exceptionHandlerWave.fromClass(this.service.getClass()).add(JRebirthItems.exceptionItem, (Object)e).relatedWave(this.wave);
            LOGGER.log(SERVICE_TASK_HANDLE_EXCEPTION, (Throwable)e, new Object[]{e.getClass().getSimpleName(), this.getServiceHandlerName()});
            this.service.sendWave(exceptionHandlerWave);
        } else {
            LOGGER.log(SERVICE_TASK_NOT_MANAGED_EXCEPTION, (Throwable)e, new Object[]{e.getClass().getSimpleName(), this.getServiceHandlerName()});
        }
    }

    private void sendReturnWave(T res) throws CoreException {
        Wave returnWave = null;
        WaveType responseWaveType = this.wave.waveType().returnWaveType();
        Class responseCommandClass = this.wave.waveType().returnCommandClass();
        if (responseWaveType != null) {
            if (responseWaveType != JRebirthWaves.RETURN_VOID && responseWaveType.items().isEmpty()) {
                LOGGER.log(NO_RETURNED_WAVE_ITEM);
                throw new CoreException(NO_RETURNED_WAVE_ITEM);
            }
            WaveItemBase resultWaveItem = (WaveItemBase)responseWaveType.items().get(0);
            returnWave = responseCommandClass != null ? Builders.wave().waveGroup(WaveGroup.CALL_COMMAND).fromClass(this.service.getClass()).componentClass(responseCommandClass) : Builders.wave().waveType(responseWaveType).fromClass(this.service.getClass());
            if (resultWaveItem != null) {
                returnWave.addDatas(new WaveData[]{Builders.waveData(resultWaveItem, res)});
            }
        } else {
            LOGGER.log(NO_RETURNED_WAVE_TYPE_DEFINED, new Object[]{this.wave.waveType()});
            throw new CoreException(NO_RETURNED_WAVE_ITEM, new Object[]{this.wave.waveType()});
        }
        returnWave.relatedWave(this.wave);
        returnWave.addWaveListener((WaveListener)new ServiceTaskReturnWaveListener());
        this.service.sendWave(returnWave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(long workDone, long totalWork) {
        ServiceTaskBase serviceTaskBase = this;
        synchronized (serviceTaskBase) {
            this.localWorkDone = workDone;
        }
        super.updateProgress(workDone, totalWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(double workDone, double totalWork) {
        ServiceTaskBase serviceTaskBase = this;
        synchronized (serviceTaskBase) {
            this.localWorkDone = workDone;
        }
        super.updateProgress(workDone, totalWork);
    }

    public void updateMessage(String message) {
        super.updateMessage(message);
    }

    public void updateTitle(String title) {
        super.updateTitle(title);
    }

    public void taskAchieved() {
        this.service.removePendingTask(this.wave.getWUID());
    }

    public Wave getAssociatedWave() {
        return this.wave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkProgressRatio(double newWorkDone, double totalWork, double amountThreshold) {
        double currentRatio;
        ServiceTaskBase serviceTaskBase = this;
        synchronized (serviceTaskBase) {
            currentRatio = this.localWorkDone >= 0.0 ? 100.0 * this.localWorkDone / totalWork : 0.0;
        }
        double newRatio = 100.0 * newWorkDone / totalWork;
        return newRatio - currentRatio > amountThreshold;
    }

    public RunnablePriority getPriority() {
        return this.priority;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }
}

