/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service;

import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.service.ServiceMessages;

public final class ServiceTaskReturnWaveListener
implements WaveListener,
ServiceMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ServiceTaskReturnWaveListener.class);

    public void waveCreated(Wave wave) {
    }

    public void waveSent(Wave wave) {
    }

    public void waveProcessed(Wave wave) {
    }

    public void waveCancelled(Wave wave) {
    }

    public void waveConsumed(Wave wave) {
        if (wave.relatedWave() != null) {
            LOGGER.trace(SERVICE_TASK_RETURN_CONSUMES, new Object[]{wave.fromClass().getSimpleName(), wave.relatedWave().toString()});
            wave.relatedWave().status(Wave.Status.Consumed);
        }
    }

    public void waveHandled(Wave wave) {
        if (wave.relatedWave() != null) {
            LOGGER.trace(SERVICE_TASK_RETURN_HANDLES, new Object[]{wave.fromClass().getSimpleName(), wave.relatedWave().toString()});
            wave.relatedWave().status(Wave.Status.Handled);
        }
    }

    public void waveFailed(Wave wave) {
        if (wave.relatedWave() != null) {
            LOGGER.log(SERVICE_TASK_HAS_FAILED, new Object[]{wave.componentClass().getSimpleName(), wave.relatedWave().toString()});
            wave.relatedWave().status(Wave.Status.Failed);
        }
    }

    public void waveDestroyed(Wave wave) {
    }
}

