/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service.basic;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneBuilder;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPaneBuilder;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.command.basic.stage.StageWaveBean;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.core.wave.Builders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageService
extends DefaultService {
    public static final WaveType DO_OPEN_STAGE = Builders.waveType("OPEN_STAGE").returnAction("STAGE_OPENED");
    public static final WaveType DO_CLOSE_STAGE = Builders.waveType("CLOSE_STAGE").returnAction("STAGE_CLOSED");
    public static final WaveType DO_DESTROY_STAGE = Builders.waveType("DESTROY_STAGE").returnAction("STAGE_DESTROYED");
    private static final Logger LOGGER = LoggerFactory.getLogger(StageService.class);
    private final Map<String, Stage> stageMap = new HashMap<String, Stage>();

    @Override
    public void initService() {
        this.listen(DO_OPEN_STAGE);
        this.listen(DO_CLOSE_STAGE);
        this.listen(DO_DESTROY_STAGE);
    }

    public void doOpenStage(Wave wave) {
        LOGGER.trace("Open a stage.");
        StageWaveBean swb = this.getWaveBean(wave);
        String stageKey = swb.stageKey();
        if (this.stageMap.containsKey(stageKey) && this.stageMap.get(stageKey) != null) {
            this.stageMap.get(stageKey).show();
        } else {
            Region rootPane = this.getRootPane(swb);
            Scene scene = this.getScene(swb, rootPane);
            Stage stage = this.getStage(swb, scene);
            this.stageMap.put(stageKey, stage);
            stage.show();
        }
    }

    private Region getRootPane(StageWaveBean swb) {
        return swb.rootPane() == null ? StackPaneBuilder.create().build() : swb.rootPane();
    }

    private Scene getScene(StageWaveBean swb, Region region) {
        Scene scene = swb.scene();
        if (scene == null) {
            scene = SceneBuilder.create().root((Parent)region).build();
        } else {
            scene.setRoot((Parent)region);
        }
        return scene;
    }

    private Stage getStage(StageWaveBean swb, Scene scene) {
        Stage stage = swb.stage();
        if (swb.stage() == null) {
            stage = StageBuilder.create().scene(scene).build();
        } else {
            stage.setScene(scene);
        }
        return stage;
    }

    public void doCloseStage(Wave wave) {
        String stageKey = this.getWaveBean(wave).stageKey();
        this.stageMap.get(stageKey).close();
    }

    public void doDestroyStage(Wave wave) {
        String stageKey = this.getWaveBean(wave).stageKey();
        this.stageMap.get(stageKey).close();
        this.stageMap.remove(stageKey);
    }

    public StageWaveBean getWaveBean(Wave wave) {
        return (StageWaveBean)wave.waveBean(StageWaveBean.class);
    }

    public Stage getStage(String stageKey) {
        return this.stageMap.get(stageKey);
    }
}

