/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.service.basic;

import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import org.jrebirth.af.api.service.ServiceTask;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.core.service.ServiceTaskBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTrackerService
extends DefaultService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTrackerService.class);
    private final ObservableList<ServiceTask<?>> serviceTasks = FXCollections.observableList(new ArrayList());
    private final EventHandler<WorkerStateEvent> workerHandler = new EventHandler<WorkerStateEvent>(){

        public void handle(WorkerStateEvent event) {
            TaskTrackerService.this.serviceTasks.remove((Object)event.getSource());
        }
    };

    public void trackTask(ServiceTaskBase<?> task) {
        LOGGER.trace("track a Task");
        this.serviceTasks.add(task);
        task.setOnCancelled(this.workerHandler);
        task.setOnSucceeded(this.workerHandler);
        task.setOnFailed(this.workerHandler);
    }

    public ObservableList<ServiceTask<?>> getServiceTasks() {
        return this.serviceTasks;
    }
}

