/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.jrebirth.af.api.concurrent.RunType;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.annotation.AutoRelease;
import org.jrebirth.af.api.ui.annotation.CreateViewIntoJAT;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.component.behavior.AbstractBehavioredComponent;
import org.jrebirth.af.core.concurrent.JRebirth;
import org.jrebirth.af.core.util.ClassUtility;

public abstract class AbstractBaseModel<M extends Model>
extends AbstractBehavioredComponent<Model>
implements Model {
    private boolean viewDisplayed;
    protected boolean createViewIntoJAT;

    public AbstractBaseModel() {
        CreateViewIntoJAT cvij = this.getClass().getAnnotation(CreateViewIntoJAT.class);
        this.createViewIntoJAT = cvij == null ? false : cvij.value();
    }

    @Override
    protected final void ready() throws CoreException {
        this.initInternalModel();
        JRebirth.run(this.createViewIntoJAT ? RunType.JAT_SYNC : RunType.SAME, this::prepareView);
        this.attachParentListener();
        this.bindInternal();
    }

    protected abstract void prepareView();

    protected abstract void initInternalModel() throws CoreException;

    protected abstract void initModel();

    protected abstract void bindInternal();

    protected abstract void bind();

    protected final void showInternalView(Wave wave) {
        this.showView();
        if (this.getView() != null) {
            if (this.viewDisplayed) {
                this.getView().reload();
            } else {
                this.getView().start();
                this.viewDisplayed = true;
            }
        }
        if (this.getInnerComponentList().isPresent()) {
            this.getInnerComponentList().get().stream().filter(s -> s instanceof AbstractBaseModel).forEach(model -> ((AbstractBaseModel)model).doShowView(wave));
        }
    }

    protected abstract void showView();

    protected final void hideInternalView(Wave wave) {
        this.hideView();
        if (this.getView() != null) {
            this.getView().hide();
        }
        if (this.getInnerComponentList().isPresent()) {
            this.getInnerComponentList().get().stream().filter(s -> s instanceof AbstractBaseModel).forEach(model -> ((AbstractBaseModel)model).doHideView(wave));
        }
    }

    protected abstract void hideView();

    public Node getRootNode() {
        return this.getView() == null ? null : this.getView().getRootNode();
    }

    @Override
    protected abstract void processWave(Wave var1);

    protected void finalize() throws Throwable {
        this.getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.DESTROY_MODEL, null, this.getClass(), new String[0]);
        super.finalize();
    }

    protected void attachParentListener() {
        AutoRelease ar = ClassUtility.getLastClassAnnotation(this.getClass(), AutoRelease.class);
        if (ar != null && ar.value() && this.getRootNode() != null) {
            this.getRootNode().parentProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                    if (newValue == null) {
                        AbstractBaseModel.this.release();
                        AbstractBaseModel.this.getRootNode().parentProperty().removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }
}

