/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Callback;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.command.CommandBean;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.service.Service;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.ui.AbstractBaseController;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;
import org.jrebirth.af.core.wave.JRebirthWaves;

public abstract class AbstractController<M extends Model, V extends View<M, ?, ?>>
extends AbstractBaseController<M, V> {
    public AbstractController(V view) throws CoreException {
        super(view);
    }

    protected <E extends Event> void linkWave(Node node, EventType<E> eventType, WaveType waveType, WaveData<?> ... waveData) {
        this.linkWave(node, eventType, waveType, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkWave(Node node, EventType<E> eventType, final WaveType waveType, final Callback<E, Boolean> callback, final WaveData<?> ... waveData) {
        node.addEventHandler(eventType, (EventHandler)new AbstractNamedEventHandler<E>("LinkWave"){

            public void handle(E event) {
                if (callback == null || ((Boolean)callback.call(event)).booleanValue()) {
                    AbstractController.this.getModel().sendWave(waveType, waveData);
                }
            }
        });
    }

    protected <E extends Event> void linkCommand(Node node, EventType<E> eventType, Class<? extends Command> commandClass, WaveData<?> ... waveData) {
        this.linkCommand(node, eventType, commandClass, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkCommand(Node node, EventType<E> eventType, Class<? extends Command> commandClass, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.getModel().callCommand(commandClass, waveData);
            }
        });
    }

    protected <E extends Event> void linkUi(Node node, EventType<E> eventType, Class<? extends Model> modelClass, WaveData<?> ... waveData) {
        this.linkUi(node, eventType, modelClass, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkUi(Node node, EventType<E> eventType, Class<? extends Model> modelClass, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        boolean noHookFound = true;
        for (int i = 0; i < waveData.length && noHookFound; ++i) {
            WaveData<?> wd = waveData[i];
            if (!JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER.equals(wd.getKey()) && !JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER.equals(wd.getKey()) || wd.getValue() == null) continue;
            noHookFound = false;
        }
        if (noHookFound) {
            throw new CoreRuntimeException("LinkUi must be called with either JRebirthWaves.ATTACH_UI_NODE_PLACEHOLDER or JRebirthWaves.ADD_UI_CHILDREN_PLACEHOLDER Wave Data provided");
        }
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.getModel().attachUi(modelClass, waveData);
            }
        });
    }

    protected <E extends Event> void linkService(Node node, EventType<E> eventType, Class<? extends Service> serviceClass, WaveType waveType, WaveData<?> ... waveData) {
        this.linkService(node, eventType, serviceClass, waveType, (Callback<E, Boolean>)null, waveData);
    }

    protected <E extends Event> void linkService(Node node, EventType<E> eventType, Class<? extends Service> serviceClass, WaveType waveType, Callback<E, Boolean> callback, WaveData<?> ... waveData) {
        node.addEventHandler(eventType, event -> {
            if (callback == null || ((Boolean)callback.call((Object)event)).booleanValue()) {
                this.getModel().returnData(serviceClass, waveType, waveData);
            }
        });
    }

    protected Wave callCommand(Class<? extends Command> commandClass, WaveData<?> ... data) {
        return this.getModel().callCommand(commandClass, data);
    }

    protected <WB extends WaveBean> Wave callCommand(Class<? extends CommandBean<WB>> commandClass, WB waveBean) {
        return this.getModel().callCommand(commandClass, waveBean);
    }
}

