/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.NullView;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.ui.annotation.AutoRelease;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.core.ui.AbstractBaseModel;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.wave.JRebirthWaves;

@AutoRelease
public abstract class AbstractModel<M extends Model, V extends View<?, ?, ?>>
extends AbstractBaseModel<M> {
    private transient V view;

    @Override
    protected void prepareView() {
        try {
            if (this.getView() != null) {
                this.getView().prepare();
            }
        }
        catch (CoreException ce) {
            throw new CoreRuntimeException((Throwable)ce);
        }
    }

    @Override
    protected void initInternalModel() throws CoreException {
        this.listen(JRebirthWaves.SHOW_VIEW);
        this.listen(JRebirthWaves.HIDE_VIEW);
        this.initModel();
    }

    @Override
    protected void bindInternal() {
        this.bind();
    }

    public final void doShowView(Wave wave) {
        this.showInternalView(wave);
    }

    public final void doHideView(Wave wave) {
        this.hideInternalView(wave);
    }

    public final V getView() {
        if (this.view == null) {
            this.buildView();
        }
        return this.view;
    }

    protected void buildView() {
        Class<?> viewClass = ClassUtility.findGenericClass(this.getClass(), View.class);
        if (viewClass != null && !NullView.class.equals(viewClass)) {
            try {
                this.view = (View)ClassUtility.buildGenericType(this.getClass(), View.class, this);
            }
            catch (CoreException e) {
                throw new CoreRuntimeException("Failure while building the view for model " + this.getClass(), (Throwable)e);
            }
        }
    }
}

