/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javafx.animation.Animation;
import javafx.event.ActionEvent;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.PaneBuilder;
import javafx.stage.Window;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Controller;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.NullController;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.ui.annotation.AutoHandler;
import org.jrebirth.af.api.ui.annotation.OnFinished;
import org.jrebirth.af.api.ui.annotation.RootNodeClass;
import org.jrebirth.af.api.ui.annotation.RootNodeId;
import org.jrebirth.af.api.ui.annotation.type.EnumEventType;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.ui.AbstractController;
import org.jrebirth.af.core.ui.UIMessages;
import org.jrebirth.af.core.ui.handler.AnnotationEventHandler;
import org.jrebirth.af.core.util.ClassUtility;

public abstract class AbstractView<M extends Model, N extends Node, C extends Controller<?, ?>>
implements View<M, N, C> {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(AbstractView.class);
    private static final String BASE_ANNOTATION_NAME = "org.jrebirth.af.api.ui.annotation.On";
    private final transient M model;
    private transient C controller;
    private transient N rootNode;
    private transient Pane errorNode;
    private Object callbackObject;

    public AbstractView(M model) {
        this.model = model;
        this.getModel().getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.CREATE_VIEW, this.getModel().getClass(), this.getClass(), new String[0]);
        try {
            this.rootNode = this.buildRootNode();
            this.buildController();
        }
        catch (CoreException ce) {
            this.controller = null;
            this.rootNode = null;
            LOGGER.log(UIMessages.CREATION_FAILURE, (Throwable)ce, new Object[]{this.getClass().getName()});
            this.buildErrorNode(ce);
        }
    }

    private void buildErrorNode(CoreException ce) {
        TextArea ta = ((TextAreaBuilder)TextAreaBuilder.create().text(ce.getMessage())).build();
        this.errorNode = PaneBuilder.create().children(new Node[]{ta}).build();
    }

    public void prepare() throws CoreException {
        this.initInternalView();
        this.getController().activate();
        this.processViewAnnotation();
        this.processFields();
    }

    private void processViewAnnotation() {
        RootNodeClass rnc;
        AutoHandler ah = ClassUtility.getLastClassAnnotation(this.getClass(), AutoHandler.class);
        this.callbackObject = ah != null && ah.value() == AutoHandler.CallbackObject.View ? this : this.getController();
        RootNodeId rni = ClassUtility.getLastClassAnnotation(this.getClass(), RootNodeId.class);
        if (rni != null) {
            this.getRootNode().setId(rni.value().isEmpty() ? this.getClass().getSimpleName() : rni.value());
        }
        if ((rnc = ClassUtility.getLastClassAnnotation(this.getClass(), RootNodeClass.class)) != null && rnc.value().length > 0) {
            for (String styleClass : rnc.value()) {
                if (styleClass == null || styleClass.isEmpty()) continue;
                this.getRootNode().getStyleClass().add((Object)styleClass);
            }
        }
        for (Annotation a : this.getClass().getAnnotations()) {
            if (!a.annotationType().getName().startsWith(BASE_ANNOTATION_NAME)) continue;
            try {
                if (this.getRootNode() == null || !(this.getController() instanceof AbstractController)) continue;
                this.addHandler((EventTarget)this.getRootNode(), a);
            }
            catch (IllegalArgumentException | CoreException e) {
                LOGGER.log(UIMessages.VIEW_ANNO_PROCESSING_FAILURE, e, new Object[]{this.getClass().getName()});
            }
        }
    }

    private void processFields() throws CoreException {
        Class<?> currentClass = this.getClass();
        for (Field f : currentClass.getDeclaredFields()) {
            if (!Node.class.isAssignableFrom(f.getType()) && !Animation.class.isAssignableFrom(f.getType())) continue;
            boolean needToHide = false;
            if (!f.isAccessible()) {
                f.setAccessible(true);
                needToHide = true;
            }
            this.processAnnotations(f);
            if (!needToHide || !f.isAccessible()) continue;
            f.setAccessible(false);
        }
    }

    private void processAnnotations(Field property) throws CoreException {
        for (Annotation a : property.getAnnotations()) {
            if (EventTarget.class.isAssignableFrom(property.getType())) {
                if (!a.annotationType().getName().startsWith(BASE_ANNOTATION_NAME)) continue;
                try {
                    EventTarget target = (EventTarget)property.get(this);
                    if (target == null || !(this.getController() instanceof AbstractController)) continue;
                    this.addHandler(target, a);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.log(UIMessages.NODE_ANNO_PROCESSING_FAILURE, (Throwable)e, new Object[]{this.getClass().getName(), property.getName()});
                }
                continue;
            }
            if (!Animation.class.isAssignableFrom(property.getType()) || !OnFinished.class.getName().equals(a.annotationType().getName())) continue;
            try {
                Animation animation = (Animation)property.get(this);
                if (animation == null || !(this.getController() instanceof AbstractController)) continue;
                this.addHandler(animation, a);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.log(UIMessages.ANIM_ANNO_PROCESSING_FAILURE, (Throwable)e, new Object[]{this.getClass().getName(), property.getName()});
            }
        }
    }

    private void addHandler(EventTarget target, Annotation annotation) throws CoreException {
        AnnotationEventHandler aeh = new AnnotationEventHandler(this.callbackObject, annotation);
        for (EnumEventType eet : (EnumEventType[])ClassUtility.getAnnotationAttribute(annotation, "value")) {
            if (target instanceof Node) {
                ((Node)target).addEventHandler(eet.eventType(), aeh);
                continue;
            }
            if (target instanceof MenuItem) {
                if (eet.eventType() == ActionEvent.ACTION) {
                    ((MenuItem)target).addEventHandler(ActionEvent.ACTION, new AnnotationEventHandler(this.callbackObject, annotation));
                    continue;
                }
                ((MenuItem)target).setOnMenuValidation(aeh);
                continue;
            }
            if (!(target instanceof Window)) continue;
            ((Window)target).addEventHandler(eet.eventType(), aeh);
        }
    }

    private void addHandler(Animation animation, Annotation annotation) throws CoreException {
        AnnotationEventHandler aeh = new AnnotationEventHandler(this.callbackObject, annotation);
        animation.setOnFinished(aeh);
    }

    public abstract void start();

    public abstract void reload();

    public abstract void hide();

    protected N buildRootNode() throws CoreException {
        return (N)((Node)ClassUtility.buildGenericType(this.getClass(), Node.class, new Object[0]));
    }

    protected void buildController() throws CoreException {
        if (!NullController.class.equals(ClassUtility.findGenericClass(this.getClass(), Controller.class))) {
            this.controller = (Controller)ClassUtility.buildGenericType(this.getClass(), Controller.class, this);
        }
    }

    public final M getModel() {
        return this.model;
    }

    public final C getController() {
        return this.controller;
    }

    public final N getRootNode() {
        return this.rootNode;
    }

    public final Pane getErrorNode() {
        return this.errorNode;
    }

    protected final void initInternalView() {
        this.initView();
    }

    protected abstract void initView();

    protected void finalize() throws Throwable {
        this.getModel().getLocalFacade().getGlobalFacade().trackEvent(JRebirthEventType.DESTROY_VIEW, null, this.getClass(), new String[0]);
        super.finalize();
    }
}

