/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.fxml;

import javafx.scene.Node;
import org.jrebirth.af.api.resource.fxml.FXMLItem;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.NullView;
import org.jrebirth.af.api.ui.fxml.FXMLComponent;
import org.jrebirth.af.api.ui.fxml.FXMLController;
import org.jrebirth.af.core.ui.fxml.FXMLUtils;
import org.jrebirth.af.core.ui.object.AbstractObjectModel;

public abstract class AbstractFXMLObjectModel<M extends Model, O>
extends AbstractObjectModel<M, NullView, O> {
    public static final String KEYPART_FXML_PREFIX = "fxml:";
    public static final String KEYPART_RB_PREFIX = "rb:";
    private String fxmlPath;
    private String resourcePath;
    private FXMLItem fxmlItem;
    private FXMLComponent fxmlComponent;

    protected FXMLItem getFXMLItem() {
        return this.fxmlItem;
    }

    protected String getFXMLPath() {
        return this.fxmlPath;
    }

    protected String getFXMLBundlePath() {
        return this.resourcePath;
    }

    @Override
    protected void prepareView() {
        this.fxmlPreInitialize();
        if (this.getFXMLItem() != null) {
            this.fxmlComponent = this.getFXMLItem().get();
            if (this.fxmlComponent.getController() != null) {
                this.fxmlComponent.getController().setModel((Model)this);
            }
        } else if (this.getFXMLPath() != null) {
            this.fxmlComponent = FXMLUtils.loadFXML(this, this.getFXMLPath(), this.getFXMLBundlePath());
        }
    }

    @Override
    protected final void bindInternal() {
        this.bind();
    }

    protected void fxmlPreInitialize() {
        if (!this.getListKeyPart().isEmpty() && this.getListKeyPart().get(0) instanceof FXMLItem) {
            this.fxmlItem = (FXMLItem)this.getListKeyPart().get(0);
        } else if (!this.getListKeyPart().isEmpty() && this.getListKeyPart().get(0).toString().startsWith(KEYPART_FXML_PREFIX)) {
            String baseName = this.getListKeyPart().get(0).toString().substring(KEYPART_FXML_PREFIX.length());
            this.fxmlPath = baseName.replaceAll("\\.", "/") + ".fxml";
            this.resourcePath = this.getListKeyPart().size() > 1 && this.getListKeyPart().get(1).toString().startsWith(KEYPART_RB_PREFIX) ? this.getListKeyPart().get(1).toString().substring(KEYPART_RB_PREFIX.length()).replaceAll("\\.", "/") : baseName;
        } else {
            String baseName = this.getClass().getCanonicalName();
            baseName = baseName.substring(0, baseName.lastIndexOf(Model.class.getSimpleName()));
            baseName = baseName.replaceAll("\\.", "/");
            this.fxmlPath = baseName + ".fxml";
            this.resourcePath = baseName;
        }
    }

    @Override
    public Node getRootNode() {
        return this.fxmlComponent.getNode();
    }

    public FXMLController<M, ?> getFXMLController() {
        return this.fxmlComponent.getController();
    }
}

