/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.fxml;

import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.text.TextBuilder;
import javafx.util.Callback;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.fxml.FXMLController;
import org.jrebirth.af.api.ui.fxml.FXMLControllerFactory;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.ui.fxml.AbstractFXMLController;
import org.jrebirth.af.core.ui.fxml.DefaultFXMLControllerFactory;
import org.jrebirth.af.core.ui.fxml.FXMLComponentBase;
import org.jrebirth.af.core.ui.fxml.FXMLMessages;
import org.jrebirth.af.core.util.ParameterUtility;

public final class FXMLUtils
implements FXMLMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(FXMLUtils.class);

    private FXMLUtils() {
    }

    public static <M extends Model> FXMLComponentBase loadFXML(M model, String fxmlPath) {
        return FXMLUtils.loadFXML(model, fxmlPath, null);
    }

    public static <M extends Model> FXMLComponentBase loadFXML(M model, String fxmlPath, String bundlePath) {
        FXMLLoader fxmlLoader = new FXMLLoader();
        Callback fxmlControllerFactory = (Callback)ParameterUtility.buildCustomizableClass(JRebirthParameters.FXML_CONTROLLER_FACTORY, DefaultFXMLControllerFactory.class, "FXMLCOntrollerFactory");
        if (fxmlControllerFactory instanceof FXMLControllerFactory) {
            ((FXMLControllerFactory)fxmlControllerFactory).setRelatedModel(model);
        }
        fxmlLoader.setControllerFactory(fxmlControllerFactory);
        fxmlLoader.setLocation(FXMLUtils.convertFxmlUrl(model, fxmlPath));
        try {
            if (bundlePath != null) {
                fxmlLoader.setResources(ResourceBundle.getBundle(bundlePath));
            }
        }
        catch (MissingResourceException e) {
            LOGGER.log(MISSING_RESOURCE_BUNDLE, (Throwable)e, new Object[]{bundlePath});
        }
        Object node = null;
        boolean error = false;
        try {
            boolean bl = error = fxmlLoader.getLocation() == null;
            node = error ? TextBuilder.create().text(FXML_ERROR_NODE_LABEL.getText(new Object[]{fxmlPath})).build() : (Node)fxmlLoader.load(fxmlLoader.getLocation().openStream());
        }
        catch (IOException e) {
            throw new CoreRuntimeException(FXML_NODE_DOESNT_EXIST.getText(new Object[]{fxmlPath}), (Throwable)e);
        }
        FXMLController fxmlController = (FXMLController)fxmlLoader.getController();
        if (fxmlController != null) {
            if (!error && !(fxmlLoader.getController() instanceof AbstractFXMLController)) {
                throw new CoreRuntimeException(BAD_FXML_CONTROLLER_ANCESTOR.getText(new Object[]{fxmlLoader.getController().getClass().getCanonicalName()}));
            }
            fxmlController.setModel(model);
        }
        return new FXMLComponentBase((Node)node, fxmlController);
    }

    private static <M extends Model> URL convertFxmlUrl(M model, String fxmlPath) {
        URL fxmlUrl = null;
        if (model != null) {
            fxmlUrl = model.getClass().getResource(fxmlPath);
        }
        if (fxmlUrl == null) {
            fxmlUrl = Thread.currentThread().getContextClassLoader().getResource(fxmlPath);
        }
        return fxmlUrl;
    }
}

