/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import javafx.event.EventType;
import javafx.scene.input.DragEvent;
import org.jrebirth.af.core.ui.adapter.DragAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;

public final class DragHandler
extends AbstractNamedEventHandler<DragEvent> {
    private final DragAdapter dragAdapter;

    public DragHandler(DragAdapter dragAdapter) {
        super(DragHandler.class.getSimpleName());
        this.dragAdapter = dragAdapter;
    }

    public DragAdapter getDragAdapter() {
        return this.dragAdapter;
    }

    public void handle(DragEvent dragEvent) {
        EventType type = dragEvent.getEventType();
        if (DragEvent.DRAG_DONE == type) {
            this.getDragAdapter().dragDone(dragEvent);
        } else if (DragEvent.DRAG_DROPPED == type) {
            this.getDragAdapter().dragDropped(dragEvent);
        } else if (DragEvent.DRAG_ENTERED == type) {
            this.getDragAdapter().dragEntered(dragEvent);
        } else if (DragEvent.DRAG_ENTERED_TARGET == type) {
            this.getDragAdapter().dragEnteredTarget(dragEvent);
        } else if (DragEvent.DRAG_EXITED == type) {
            this.getDragAdapter().dragExited(dragEvent);
        } else if (DragEvent.DRAG_EXITED_TARGET == type) {
            this.getDragAdapter().dragExitedTarget(dragEvent);
        } else if (DragEvent.DRAG_OVER == type) {
            this.getDragAdapter().dragOver(dragEvent);
        } else {
            this.getDragAdapter().drag(dragEvent);
        }
    }
}

