/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import javafx.event.EventType;
import javafx.scene.input.MouseEvent;
import org.jrebirth.af.core.ui.adapter.MouseAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;

public final class MouseHandler
extends AbstractNamedEventHandler<MouseEvent> {
    private final MouseAdapter mouseAdapter;

    public MouseHandler(MouseAdapter mouseAdapter) {
        super(MouseHandler.class.getSimpleName());
        this.mouseAdapter = mouseAdapter;
    }

    public MouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public void handle(MouseEvent mouseEvent) {
        EventType type = mouseEvent.getEventType();
        if (MouseEvent.DRAG_DETECTED == type) {
            this.getMouseAdapter().mouseDragDetected(mouseEvent);
        } else if (MouseEvent.MOUSE_CLICKED == type) {
            this.getMouseAdapter().mouseClicked(mouseEvent);
        } else if (MouseEvent.MOUSE_DRAGGED == type) {
            this.getMouseAdapter().mouseDragged(mouseEvent);
        } else if (MouseEvent.MOUSE_ENTERED == type) {
            this.getMouseAdapter().mouseEntered(mouseEvent);
        } else if (MouseEvent.MOUSE_ENTERED_TARGET == type) {
            this.getMouseAdapter().mouseEnteredTarget(mouseEvent);
        } else if (MouseEvent.MOUSE_EXITED == type) {
            this.getMouseAdapter().mouseExited(mouseEvent);
        } else if (MouseEvent.MOUSE_EXITED_TARGET == type) {
            this.getMouseAdapter().mouseExitedTarget(mouseEvent);
        } else if (MouseEvent.MOUSE_MOVED == type) {
            this.getMouseAdapter().mouseMoved(mouseEvent);
        } else if (MouseEvent.MOUSE_PRESSED == type) {
            this.getMouseAdapter().mousePressed(mouseEvent);
        } else if (MouseEvent.MOUSE_RELEASED == type) {
            this.getMouseAdapter().mouseReleased(mouseEvent);
        } else {
            this.getMouseAdapter().mouse(mouseEvent);
        }
    }
}

