/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import javafx.event.EventType;
import javafx.scene.input.SwipeEvent;
import org.jrebirth.af.core.ui.adapter.SwipeAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;

public final class SwipeHandler
extends AbstractNamedEventHandler<SwipeEvent> {
    private final SwipeAdapter swipeAdapter;

    public SwipeHandler(SwipeAdapter swipeAdapter) {
        super(SwipeHandler.class.getSimpleName());
        this.swipeAdapter = swipeAdapter;
    }

    public SwipeAdapter getSwipeAdapter() {
        return this.swipeAdapter;
    }

    public void handle(SwipeEvent swipeEvent) {
        EventType type = swipeEvent.getEventType();
        if (SwipeEvent.SWIPE_DOWN == type) {
            this.getSwipeAdapter().swipeDown(swipeEvent);
        } else if (SwipeEvent.SWIPE_LEFT == type) {
            this.getSwipeAdapter().swipeLeft(swipeEvent);
        } else if (SwipeEvent.SWIPE_RIGHT == type) {
            this.getSwipeAdapter().swipeRight(swipeEvent);
        } else if (SwipeEvent.SWIPE_UP == type) {
            this.getSwipeAdapter().swipeUp(swipeEvent);
        } else {
            this.getSwipeAdapter().anySwipe(swipeEvent);
        }
    }
}

