/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import javafx.event.EventType;
import javafx.scene.input.TouchEvent;
import org.jrebirth.af.core.ui.adapter.TouchAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;

public final class TouchHandler
extends AbstractNamedEventHandler<TouchEvent> {
    private final TouchAdapter touchAdapter;

    public TouchHandler(TouchAdapter touchAdapter) {
        super(TouchHandler.class.getSimpleName());
        this.touchAdapter = touchAdapter;
    }

    public TouchAdapter getTouchAdapter() {
        return this.touchAdapter;
    }

    public void handle(TouchEvent touchEvent) {
        EventType type = touchEvent.getEventType();
        if (TouchEvent.TOUCH_PRESSED == type) {
            this.getTouchAdapter().touchPressed(touchEvent);
        } else if (TouchEvent.TOUCH_RELEASED == type) {
            this.getTouchAdapter().touchReleased(touchEvent);
        } else if (TouchEvent.TOUCH_MOVED == type) {
            this.getTouchAdapter().touchMoved(touchEvent);
        } else if (TouchEvent.TOUCH_STATIONARY == type) {
            this.getTouchAdapter().touchStationary(touchEvent);
        } else {
            this.getTouchAdapter().touch(touchEvent);
        }
    }
}

