/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.handler;

import javafx.event.EventType;
import javafx.stage.WindowEvent;
import org.jrebirth.af.core.ui.adapter.WindowAdapter;
import org.jrebirth.af.core.ui.handler.AbstractNamedEventHandler;

public final class WindowHandler
extends AbstractNamedEventHandler<WindowEvent> {
    private final WindowAdapter windowAdapter;

    public WindowHandler(WindowAdapter windowAdapter) {
        super(WindowHandler.class.getSimpleName());
        this.windowAdapter = windowAdapter;
    }

    public WindowAdapter getWindowAdapter() {
        return this.windowAdapter;
    }

    public void handle(WindowEvent windowEvent) {
        EventType type = windowEvent.getEventType();
        if (WindowEvent.WINDOW_CLOSE_REQUEST == type) {
            this.getWindowAdapter().windowCloseRequest(windowEvent);
        } else if (WindowEvent.WINDOW_HIDDEN == type) {
            this.getWindowAdapter().windowHidden(windowEvent);
        } else if (WindowEvent.WINDOW_HIDING == type) {
            this.getWindowAdapter().windowHiding(windowEvent);
        } else if (WindowEvent.WINDOW_SHOWING == type) {
            this.getWindowAdapter().windowShowing(windowEvent);
        } else if (WindowEvent.WINDOW_SHOWN == type) {
            this.getWindowAdapter().windowShown(windowEvent);
        } else {
            this.getWindowAdapter().window(windowEvent);
        }
    }
}

