/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.ui.object;

import javafx.scene.Node;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.ui.Controller;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.ui.View;
import org.jrebirth.af.api.ui.object.ModelObject;
import org.jrebirth.af.core.ui.AbstractModel;
import org.jrebirth.af.core.util.ClassUtility;

public abstract class AbstractObjectModel<M extends Model, V extends View<?, ?, ?>, O>
extends AbstractModel<M, V>
implements ModelObject<O> {
    private static final Class<?>[] OBJECT_EXCLUDED_CLASSES = new Class[]{Model.class, View.class, Node.class, Controller.class};
    private O object;

    public final O getObject() {
        if (this.object == null) {
            this.buildObject();
        }
        return this.object;
    }

    protected void buildObject() {
        Class<?> objectType = ClassUtility.findGenericClass(this.getClass(), OBJECT_EXCLUDED_CLASSES);
        if (objectType != null) {
            Object keyPart = null;
            boolean found = false;
            for (int i = 0; !found && i < this.getListKeyPart().size(); ++i) {
                keyPart = this.getListKeyPart().get(i);
                if (!objectType.isAssignableFrom(keyPart.getClass())) continue;
                this.object = keyPart;
                found = true;
            }
            if (this.object == null) {
                try {
                    this.object = ClassUtility.buildGenericType(this.getClass(), OBJECT_EXCLUDED_CLASSES, new Object[0]);
                }
                catch (CoreException e) {
                    throw new CoreRuntimeException("Failure while building the bindable object for model " + this.getClass(), (Throwable)e);
                }
            }
        }
    }

    public void setObject(O object) {
        this.object = object;
        this.bindInternal();
    }
}

