/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jrebirth.af.api.component.basic.Component;
import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.annotation.OnWave;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.util.ClassUtility;
import org.jrebirth.af.core.util.UtilMessages;
import org.jrebirth.af.core.wave.WaveTypeRegistry;

public final class CheckerUtility
implements UtilMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(CheckerUtility.class);

    private CheckerUtility() {
    }

    public static void checkWaveTypeContract(Class<? extends Component> waveReadyClass, WaveType ... waveTypes) {
        if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue()) {
            for (WaveType waveType : waveTypes) {
                int j;
                String methodName = ClassUtility.underscoreToCamelCase(waveType.toString());
                List<Method> methods = ClassUtility.retrieveMethodList(waveReadyClass, waveType.toString());
                List<Method> annotatedMethods = ClassUtility.getAnnotatedMethods(waveReadyClass, OnWave.class);
                if (methods.size() < 1 && annotatedMethods.size() < 1) {
                    LOGGER.log(BROKEN_API_NO_METHOD, new Object[]{waveReadyClass.getSimpleName(), methodName});
                    LOGGER.log(WAVE_HANDLER_METHOD_REQUIRED, new Object[]{waveReadyClass.getSimpleName(), methodName, waveType.items()});
                }
                int methodParameters = 0;
                boolean hasCompliantMethod = false;
                List wParams = waveType.parameters();
                for (j = 0; j < methods.size() && !hasCompliantMethod; ++j) {
                    hasCompliantMethod = CheckerUtility.checkMethodSignature(methods.get(j), wParams);
                    if (hasCompliantMethod) continue;
                    methodParameters = methods.get(j).getParameterTypes().length - 1;
                }
                if (!hasCompliantMethod) {
                    for (j = 0; j < annotatedMethods.size() && !hasCompliantMethod; ++j) {
                        if (WaveTypeRegistry.getWaveType(annotatedMethods.get(j).getAnnotation(OnWave.class).value()) != waveType || (hasCompliantMethod = CheckerUtility.checkMethodSignature(annotatedMethods.get(j), wParams))) continue;
                        methodName = annotatedMethods.get(j).getName();
                        methodParameters = annotatedMethods.get(j).getParameterTypes().length - 1;
                    }
                }
                if (hasCompliantMethod) continue;
                LOGGER.log(BROKEN_API_WRONG_PARAMETERS, new Object[]{waveReadyClass.getSimpleName(), methodName, waveType.items().size(), methodParameters});
                LOGGER.log(WAVE_HANDLER_METHOD_REQUIRED, new Object[]{waveReadyClass.getSimpleName(), methodName, waveType.items()});
                throw new CoreRuntimeException(BROKEN_API_WRONG_PARAMETERS.getText(new Object[]{waveReadyClass.getSimpleName(), methodName, waveType.items().size(), methodParameters}));
            }
        }
    }

    private static boolean checkMethodSignature(Method method, List<WaveItem<?>> wParams) {
        boolean isCompliant = false;
        Type[] mParams = method.getGenericParameterTypes();
        if (wParams.isEmpty() && Wave.class.isAssignableFrom(ClassUtility.getClassFromType(mParams[0]))) {
            isCompliant = true;
        } else if (mParams.length - 1 == wParams.size()) {
            boolean skipMethod = false;
            for (int i = 0; !skipMethod && i < mParams.length - 1 && !isCompliant; ++i) {
                if (!ClassUtility.getClassFromType(mParams[i]).isAssignableFrom(ClassUtility.getClassFromType(wParams.get(i).getItemType()))) {
                    skipMethod = true;
                }
                if (i != mParams.length - 2 || !Wave.class.isAssignableFrom(ClassUtility.getClassFromType(mParams[i + 1]))) continue;
                isCompliant = true;
            }
        }
        return isCompliant;
    }

    public static void checkWave(Wave wave) {
        if (((Boolean)JRebirthParameters.DEVELOPER_MODE.get()).booleanValue() && wave.waveType() != null) {
            ArrayList<WaveItem> missingWaveItems = new ArrayList<WaveItem>();
            for (WaveItem item : wave.waveType().items()) {
                if (wave.contains(item)) continue;
                missingWaveItems.add(item);
            }
            if (!missingWaveItems.isEmpty()) {
                LOGGER.log(BROKEN_WAVE_SENT, new Object[]{wave.toString()});
                StringBuilder sb = new StringBuilder();
                for (WaveItem missing : missingWaveItems) {
                    sb.append(missing.toString());
                }
                LOGGER.log(BROKEN_WAVE_BAD_ITEM_LIST, new Object[]{sb.toString()});
                throw new CoreRuntimeException(BROKEN_WAVE_BAD_ITEM_LIST.getText(new Object[]{sb.toString()}));
            }
        }
    }
}

