/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.application.Application;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.UtilMessages;

public final class ClassUtility
implements UtilMessages {
    public static final String SEPARATOR = "|";
    private static final String CASE_SEPARATOR = "_";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ClassUtility.class);

    private ClassUtility() {
    }

    public static Object buildGenericType(Class<?> mainClass, Class<?> assignableClass, Object ... parameters) throws CoreException {
        return ClassUtility.buildGenericType(mainClass, new Class[]{assignableClass}, parameters);
    }

    public static Object buildGenericType(Class<?> mainClass, Class<?>[] assignableClasses, Object ... parameters) throws CoreException {
        Class<?> genericClass = null;
        Class[] parameterTypes = new Class[parameters.length];
        try {
            int i = 0;
            for (Object obj : parameters) {
                parameterTypes[i] = obj.getClass();
                ++i;
            }
            genericClass = ClassUtility.findGenericClass(mainClass, assignableClasses);
            Constructor<?> constructor = ClassUtility.getConstructor(genericClass, parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            StringBuilder sb = new StringBuilder("[");
            for (Class<?> assignableClass : assignableClasses) {
                sb.append(assignableClass.getName()).append(", ");
            }
            sb.append("]");
            if (genericClass == null) {
                LOGGER.log(GENERIC_TYPE_ERROR_1, (Throwable)e, new Object[]{sb.toString(), mainClass.getName()});
            } else {
                LOGGER.log(GENERIC_TYPE_ERROR_2, (Throwable)e, new Object[]{genericClass.getName(), mainClass.getName()});
            }
            if (e instanceof IllegalArgumentException) {
                LOGGER.log(ARGUMENT_LIST);
                for (int i = 0; i < parameterTypes.length; ++i) {
                    LOGGER.log(ARGUMENT_DETAIL, new Object[]{parameterTypes[i].toString(), parameters[i].toString()});
                }
            }
            if (genericClass == null) {
                throw new CoreException(GENERIC_TYPE_ERROR_1.getText(new Object[]{sb.toString(), mainClass.getName()}), (Throwable)e);
            }
            throw new CoreException(GENERIC_TYPE_ERROR_2.getText(new Object[]{genericClass.getName(), mainClass.getName()}), (Throwable)e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> genericClass, Class<?>[] parameterTypes) {
        Constructor<?> constructor = null;
        try {
            constructor = genericClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            constructor = genericClass.getConstructors()[0];
        }
        catch (SecurityException e) {
            LOGGER.log(NO_CONSTRUCTOR, (Throwable)e);
            throw e;
        }
        return constructor;
    }

    public static Class<?> findGenericClass(Class<?> mainClass, Class<?> assignableClass) {
        return ClassUtility.findGenericClass(mainClass, new Class[]{assignableClass});
    }

    public static Class<?> findGenericClass(Class<?> mainClass, Class<?>[] excludedClasses) {
        boolean excludeMode = excludedClasses.length > 1;
        ParameterizedType paramType = (ParameterizedType)mainClass.getGenericSuperclass();
        Class<?> genericClass = null;
        Class<?> tempClass = null;
        for (int i = 0; genericClass == null && i < paramType.getActualTypeArguments().length; ++i) {
            tempClass = ClassUtility.getClassFromType(paramType.getActualTypeArguments()[i]);
            if (!excludeMode && excludedClasses[0].isAssignableFrom(tempClass)) {
                genericClass = tempClass;
            }
            if (!excludeMode) continue;
            boolean excludeIt = false;
            for (Class<?> excludeClass : excludedClasses) {
                if (!excludeClass.isAssignableFrom(tempClass)) continue;
                excludeIt = true;
            }
            if (excludeIt) continue;
            genericClass = tempClass;
        }
        return genericClass;
    }

    public static String underscoreToCamelCase(String undescoredString) {
        String[] parts = undescoredString.split(CASE_SEPARATOR);
        StringBuilder camelCaseString = new StringBuilder(undescoredString.length());
        camelCaseString.append(parts[0].toLowerCase(Locale.getDefault()));
        for (int i = 1; i < parts.length; ++i) {
            camelCaseString.append(parts[i].substring(0, 1).toUpperCase(Locale.getDefault()));
            camelCaseString.append(parts[i].substring(1).toLowerCase(Locale.getDefault()));
        }
        return camelCaseString.toString();
    }

    public static String camelCaseToUnderscore(String camelCaseString) {
        StringBuilder sb = new StringBuilder();
        for (String camelPart : camelCaseString.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])")) {
            if (sb.length() > 0) {
                sb.append(CASE_SEPARATOR);
            }
            sb.append(camelPart.toUpperCase(Locale.getDefault()));
        }
        return sb.toString();
    }

    public static Method getMethodByName(Class<?> cls, String action) throws NoSuchMethodException {
        for (Method m : cls.getMethods()) {
            if (!m.getName().equals(action)) continue;
            return m;
        }
        throw new NoSuchMethodException(action);
    }

    public static List<Field> retrievePropertyList(Class<?> cls) {
        ArrayList<Field> propertyList = new ArrayList<Field>();
        for (Field f : cls.getFields()) {
            propertyList.add(f);
        }
        return propertyList;
    }

    public static Field findProperty(Class<?> sourceClass, String itemName, Class<?> searchedClass) {
        Field found = null;
        if (itemName != null && !itemName.trim().isEmpty()) {
            try {
                found = sourceClass.getField(ClassUtility.underscoreToCamelCase(itemName));
            }
            catch (NoSuchFieldException | SecurityException e) {
                found = null;
            }
        }
        if (found == null) {
            Field f = null;
            for (int i = 0; found == null && i < sourceClass.getFields().length; ++i) {
                f = sourceClass.getFields()[i];
                if (!f.getClass().equals(searchedClass)) continue;
                found = f;
            }
        }
        return found;
    }

    public static List<Method> retrieveMethodList(Class<?> cls, String methodName) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        String camelCasedMethodName = ClassUtility.underscoreToCamelCase(methodName);
        for (Method m : cls.getMethods()) {
            if (!m.getName().equals(camelCasedMethodName) && !m.getName().equals(methodName)) continue;
            methodList.add(m);
        }
        return methodList;
    }

    public static Class<?> getClassFromType(Type type) {
        Class<?> returnClass = null;
        if (type instanceof Class) {
            returnClass = (Class<?>)type;
        } else if (type instanceof ParameterizedType) {
            returnClass = ClassUtility.getClassFromType(((ParameterizedType)type).getRawType());
        }
        return returnClass;
    }

    public static <A extends Annotation> A getLastClassAnnotation(Class<?> sourceClass, Class<A> annotationClass) {
        A annotation = null;
        for (Class<?> currentClass = sourceClass; annotation == null && currentClass != null; currentClass = currentClass.getSuperclass()) {
            annotation = currentClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public static Object getAnnotationAttribute(Annotation annotation, String attributeName) {
        Object object = null;
        try {
            Method attributeMethod = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            object = attributeMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOGGER.log(NO_ANNOTATION_PROPERTY, (Throwable)e, new Object[]{attributeName});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            LOGGER.log(NO_ANNOTATION_PROPERTY_VALUE, (Throwable)e, new Object[]{attributeName});
        }
        return object;
    }

    public static Class<? extends Application> getClassFromStaticMethod(int classDeepLevel) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(Thread.currentThread().getStackTrace()[classDeepLevel].getClassName());
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        return clazz;
    }

    public static List<Method> getAnnotatedMethods(Class<?> cls, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : cls.getDeclaredMethods()) {
            if (method.getAnnotationsByType(annotationClass).length <= 0) continue;
            methodList.add(method);
        }
        for (GenericDeclaration genericDeclaration : cls.getInterfaces()) {
            methodList.addAll(ClassUtility.getAnnotatedMethods(genericDeclaration, annotationClass));
        }
        if (cls.getSuperclass() != null) {
            methodList.addAll(ClassUtility.getAnnotatedMethods(cls.getSuperclass(), annotationClass));
        }
        return methodList;
    }

    public static List<Field> getAnnotatedFields(Class<?> cls, Class<? extends Annotation> annotationClass) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Field f : cls.getDeclaredFields()) {
            if (f.getAnnotation(annotationClass) == null) continue;
            fieldList.add(f);
        }
        if (cls.getSuperclass() != null) {
            fieldList.addAll(ClassUtility.getAnnotatedFields(cls.getSuperclass(), annotationClass));
        }
        return fieldList;
    }

    public static Object callMethod(Method method, Object instance, Object ... parameters) throws CoreException {
        Object res = null;
        try {
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            res = method.invoke(instance, parameters);
            method.setAccessible(accessible);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new CoreException((Throwable)e);
        }
        return res;
    }

    public static void setFieldValue(Field field, Object instance, Object value) throws CoreException {
        try {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(accessible);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new CoreException((Throwable)e);
        }
    }

    public static Class<?> getGenericClassAssigned(Class<?> fromClass, Class<?> typeSearched) {
        Class<?> realType = null;
        Type superType = fromClass.getGenericSuperclass();
        realType = ClassUtility.searchIntoParameterzedType(superType, typeSearched);
        if (realType == null) {
            for (Type api : fromClass.getGenericInterfaces()) {
                realType = ClassUtility.searchIntoParameterzedType(api, typeSearched);
            }
        }
        if (realType == null && superType instanceof Class) {
            realType = ClassUtility.getGenericClassAssigned((Class)superType, typeSearched);
        }
        if (realType == null) {
            for (Type api : fromClass.getGenericInterfaces()) {
                if (!(api instanceof Class)) continue;
                realType = ClassUtility.getGenericClassAssigned((Class)api, typeSearched);
            }
        }
        return realType;
    }

    private static Class<?> searchIntoParameterzedType(Type superType, Class<?> typeSearched) {
        if (superType instanceof ParameterizedType) {
            for (Type genericType : ((ParameterizedType)superType).getActualTypeArguments()) {
                if (genericType instanceof Class && typeSearched.isAssignableFrom((Class)genericType)) {
                    return (Class)genericType;
                }
                if (!(genericType instanceof ParameterizedType) || !typeSearched.isAssignableFrom((Class)((ParameterizedType)genericType).getRawType())) continue;
                return (Class)((ParameterizedType)genericType).getRawType();
            }
        }
        return null;
    }
}

