/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import com.sun.javaws.jnl.JARDesc;
import com.sun.jnlp.JNLPClassLoaderIf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.UtilMessages;

public final class ClasspathUtility
implements UtilMessages {
    public static final String SEPARATOR = "|";
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ClasspathUtility.class);
    private static final String CLASSPATH = System.getProperty("java.class.path", ".");
    private static final String CLASSPATH_SEPARATOR = System.getProperty("path.separator");

    private ClasspathUtility() {
    }

    public static Collection<String> getClasspathResources(Pattern searchPattern) {
        ArrayList<String> resources = new ArrayList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (ClasspathUtility.hasJavaWebstartLibrary() && cl instanceof JNLPClassLoaderIf) {
            LOGGER.log(USE_JNLP_CLASSLOADER);
            JNLPClassLoaderIf wsLoader = (JNLPClassLoaderIf)cl;
            for (JARDesc jd : wsLoader.getLaunchDesc().getResources().getLocalJarDescs()) {
                try {
                    JarFile jarFile = wsLoader.getJarFile(jd.getLocation());
                    LOGGER.log(PARSE_CACHED_JAR_FILE, new Object[]{jarFile.getName(), jd.getLocationString()});
                    resources.addAll(ClasspathUtility.getResources(jarFile.getName(), searchPattern, true));
                }
                catch (IOException e) {
                    LOGGER.log(CANT_READ_CACHED_JAR_FILE, new Object[]{jd.getLocation()});
                }
            }
        } else {
            String[] classpathEntries;
            LOGGER.log(USE_DEFAULT_CLASSLOADER);
            for (String urlEntry : classpathEntries = CLASSPATH.split(CLASSPATH_SEPARATOR)) {
                resources.addAll(ClasspathUtility.getResources(urlEntry, searchPattern, false));
            }
        }
        Collections.sort(resources);
        return resources;
    }

    private static boolean hasJavaWebstartLibrary() {
        boolean hasWebStartLibrary = true;
        try {
            Class.forName("com.sun.jnlp.JNLPClassLoaderIf");
        }
        catch (ClassNotFoundException e) {
            hasWebStartLibrary = false;
        }
        return hasWebStartLibrary;
    }

    private static List<String> getResources(String classpathEntryPath, Pattern searchPattern, boolean cachedJar) {
        ArrayList<String> resources = new ArrayList<String>();
        File classpathEntryFile = new File(classpathEntryPath);
        if (classpathEntryFile.isDirectory()) {
            resources.addAll(ClasspathUtility.getResourcesFromDirectory(classpathEntryFile, searchPattern));
        } else if (classpathEntryFile.getName().endsWith(".jar") || classpathEntryFile.getName().endsWith(".zip") || cachedJar) {
            resources.addAll(ClasspathUtility.getResourcesFromJarOrZipFile(classpathEntryFile, searchPattern));
        } else {
            LOGGER.log(RESOURCE_IGNORED, new Object[]{classpathEntryFile.getAbsolutePath()});
        }
        return resources;
    }

    private static List<String> getResourcesFromDirectory(File directory, Pattern searchPattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null && fileList.length > 0) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    resources.addAll(ClasspathUtility.getResourcesFromDirectory(file, searchPattern));
                    continue;
                }
                try {
                    ClasspathUtility.checkResource(resources, searchPattern, file.getCanonicalPath());
                }
                catch (IOException e) {
                    LOGGER.log(BAD_CANONICAL_PATH, (Throwable)e);
                }
            }
        }
        return resources;
    }

    private static List<String> getResourcesFromJarOrZipFile(File jarOrZipFile, Pattern searchPattern) {
        ArrayList<String> resources = new ArrayList<String>();
        try (ZipFile zf = new ZipFile(jarOrZipFile);){
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                ClasspathUtility.checkResource(resources, searchPattern, ze.getName());
            }
        }
        catch (IOException e) {
            LOGGER.log(FILE_UNREADABLE, (Throwable)e);
        }
        return resources;
    }

    private static void checkResource(List<String> resources, Pattern searchPattern, String resourceName) {
        if (searchPattern.matcher(resourceName).matches()) {
            resources.add(resourceName);
        }
    }

    public static InputStream loadInputStream(String custConfFileName) {
        InputStream is = null;
        File resourceFile = new File(custConfFileName);
        if (resourceFile.exists()) {
            try {
                is = new FileInputStream(resourceFile);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(custConfFileName);
        }
        return is;
    }
}

