/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.util;

import org.jrebirth.af.api.exception.CoreRuntimeException;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.resource.parameter.ParameterItem;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.util.UtilMessages;

public final class ParameterUtility
implements UtilMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(ParameterUtility.class);

    private ParameterUtility() {
    }

    public static <D> Object buildCustomizableClass(ParameterItem<Class<?>> parameter, Class<D> defaultObject, String typeName) {
        Object object = null;
        try {
            object = ((Class)parameter.get()).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error(CUSTOM_CLASS_LOADING_ERROR, (Throwable)e, new Object[]{typeName});
            try {
                object = defaultObject.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new CoreRuntimeException("Impossible to build Default " + typeName, (Throwable)e2);
            }
        }
        return object;
    }
}

