/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.jrebirth.af.api.log.JRLogger;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveBean;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.WaveListener;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.link.LinkMessages;
import org.jrebirth.af.core.log.JRLoggerFactory;
import org.jrebirth.af.core.wave.Builders;

public class WaveBase
implements Wave,
LinkMessages {
    private static final JRLogger LOGGER = JRLoggerFactory.getLogger(WaveBase.class);
    private static final String SPACE_SEP = " ";
    private final String wuid;
    private final long timestamp;
    private final ObjectProperty<Wave.Status> statusProperty = new SimpleObjectProperty((Object)Wave.Status.Created);
    private WaveGroup waveGroup = WaveGroup.UNDEFINED;
    private WaveType waveType;
    private Class<?> fromClass;
    private Class<?> componentClass;
    private int priority;
    private Wave relatedWave;
    private final Map<WaveItem<?>, WaveData<?>> waveItemsMap = new HashMap();
    private final List<WaveData<?>> waveDataList = new ArrayList();
    private Map<Class<? extends WaveBean>, WaveBean> waveBeanMap;
    private final List<WaveListener> waveListeners = Collections.synchronizedList(new ArrayList());
    private List<? extends Object> waveHandlers;

    WaveBase() {
        this.wuid = UUID.randomUUID().toString();
        this.timestamp = System.currentTimeMillis();
    }

    public WaveGroup waveGroup() {
        return this.waveGroup;
    }

    public Wave waveGroup(WaveGroup waveGroup) {
        this.waveGroup = waveGroup;
        return this;
    }

    public WaveType waveType() {
        return this.waveType;
    }

    public Wave waveType(WaveType waveType) {
        this.waveType = waveType;
        return this;
    }

    public Class<?> fromClass() {
        return this.fromClass;
    }

    public Wave fromClass(Class<?> fromClass) {
        this.fromClass = fromClass;
        return this;
    }

    public Class<?> componentClass() {
        return this.componentClass;
    }

    public Wave componentClass(Class<?> componentClass) {
        this.componentClass = componentClass;
        return this;
    }

    public int priority() {
        return this.priority;
    }

    public Wave priority(int priority) {
        this.priority = priority;
        return this;
    }

    public Wave relatedWave() {
        return this.relatedWave;
    }

    public Wave relatedWave(Wave nextWave) {
        this.relatedWave = nextWave;
        return this;
    }

    public List<WaveData<?>> waveDatas() {
        return this.waveDataList;
    }

    public Wave addDatas(WaveData<?> ... waveDatas) {
        for (WaveData<?> waveData : waveDatas) {
            waveData.setOrder(this.waveDatas().size());
            WaveData<?> previous = this.waveItemsMap.get(waveData.getKey());
            this.waveItemsMap.put(waveData.getKey(), waveData);
            if (previous != null) {
                this.waveDataList.remove(previous);
            }
            this.waveDataList.add(waveData);
            Collections.sort(this.waveDataList);
        }
        return this;
    }

    public <T> Wave add(WaveItem<T> waveItem, T value) {
        WaveData<T> waveData = Builders.waveData(waveItem, value);
        this.addDatas(waveData);
        return this;
    }

    public <T> WaveData<T> getData(WaveItem<T> waveItem) {
        return this.waveItemsMap.get(waveItem);
    }

    public <T> T get(WaveItem<T> waveItem) {
        return (T)(this.waveItemsMap.containsKey(waveItem) ? this.waveItemsMap.get(waveItem).getValue() : null);
    }

    public boolean contains(WaveItem<?> waveItem) {
        return this.waveItemsMap.containsKey(waveItem);
    }

    public boolean containsNotNull(WaveItem<?> waveItem) {
        return this.contains(waveItem) && this.getData(waveItem).getValue() != null;
    }

    public String getWUID() {
        return this.wuid;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Wave waveBean(WaveBean waveBean) {
        this.getWaveBeanMap().put(waveBean.getClass(), waveBean);
        return this;
    }

    private Map<Class<? extends WaveBean>, WaveBean> getWaveBeanMap() {
        if (this.waveBeanMap == null) {
            this.waveBeanMap = new HashMap<Class<? extends WaveBean>, WaveBean>();
        }
        return this.waveBeanMap;
    }

    public <WB extends WaveBean> WB waveBean(Class<WB> waveBeanClass) {
        if (!this.getWaveBeanMap().containsKey(waveBeanClass)) {
            try {
                WaveBean waveBean = (WaveBean)waveBeanClass.newInstance();
                this.getWaveBeanMap().put(waveBeanClass, waveBean);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(WAVE_BEAN_CREATION_ERROR, (Throwable)e, new Object[]{waveBeanClass.toString()});
            }
        }
        return (WB)this.getWaveBeanMap().get(waveBeanClass);
    }

    public List<WaveBean> waveBeanList() {
        if (this.waveBeanMap != null && !this.waveBeanMap.isEmpty()) {
            return new ArrayList<WaveBean>(this.waveBeanMap.values());
        }
        return new ArrayList<WaveBean>();
    }

    public Wave waveBeanList(List<WaveBean> waveBeanList) {
        if (waveBeanList != null && !waveBeanList.isEmpty()) {
            waveBeanList.forEach(wb -> this.getWaveBeanMap().put((Class<? extends WaveBean>)wb.getClass(), (WaveBean)wb));
        }
        return this;
    }

    public Wave addWaveListener(WaveListener waveListener) {
        this.waveListeners.add(waveListener);
        return this;
    }

    public Wave removeWaveListener(WaveListener waveListener) {
        this.waveListeners.remove(waveListener);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wave.Status status() {
        WaveBase waveBase = this;
        synchronized (waveBase) {
            return (Wave.Status)this.statusProperty.get();
        }
    }

    public ObjectProperty<Wave.Status> statusProperty() {
        return this.statusProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wave status(Wave.Status status) {
        WaveBase waveBase = this;
        synchronized (waveBase) {
            if (this.statusProperty.get() != status) {
                this.statusProperty.set((Object)status);
                this.fireStatusChanged();
            }
        }
        return this;
    }

    private void fireStatusChanged() {
        for (WaveListener waveListener : this.waveListeners) {
            switch ((Wave.Status)this.statusProperty.get()) {
                case Created: {
                    waveListener.waveCreated((Wave)this);
                    break;
                }
                case Sent: {
                    waveListener.waveSent((Wave)this);
                    break;
                }
                case Processing: {
                    waveListener.waveProcessed((Wave)this);
                    break;
                }
                case Consumed: {
                    waveListener.waveConsumed((Wave)this);
                    break;
                }
                case Handled: {
                    waveListener.waveHandled((Wave)this);
                    break;
                }
                case Failed: {
                    waveListener.waveFailed((Wave)this);
                    break;
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.waveGroup() != null) {
            sb.append(this.waveGroup()).append(SPACE_SEP);
        }
        if (this.fromClass() != null) {
            sb.append("fromClass=").append(this.fromClass().getSimpleName()).append(SPACE_SEP);
        }
        if (this.componentClass() != null) {
            sb.append("relatedClass=").append(this.componentClass().getSimpleName()).append(SPACE_SEP);
        }
        if (this.waveType() != null) {
            sb.append(this.waveType()).append(SPACE_SEP);
        }
        if (this.getWUID() != null) {
            sb.append("(").append(this.getWUID()).append(") ");
        }
        if (this.waveDatas().size() > 0) {
            sb.append("\r\nData=>");
            for (WaveData<?> wd : this.waveDatas()) {
                sb.append(wd.getKey()).append("=").append(wd.getValue());
            }
        }
        return sb.toString();
    }

    public void setWaveHandlers(List<? extends Object> waveHandlers) {
        this.waveHandlers = waveHandlers;
    }

    public void removeWaveHandler(Object waveHandler) {
        if (waveHandler != null) {
            this.waveHandlers.remove(waveHandler);
            if (this.status() == Wave.Status.Consumed && this.waveHandlers.isEmpty()) {
                this.status(Wave.Status.Handled);
            }
        }
    }

    public boolean hasWaveBean(Class<? extends WaveBean> waveBeanClass) {
        if (this.waveBeanMap != null && !this.waveBeanMap.isEmpty()) {
            return this.waveBeanMap.containsKey(waveBeanClass);
        }
        return false;
    }
}

