/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.core.wave.WaveItemEnum;

public class WaveItemBase<T>
implements WaveItem<T> {
    private static int idGenerator;
    private int uid;
    private final Type itemType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private String name;
    private boolean isParameter;

    protected WaveItemBase() {
        this(null, true);
    }

    protected WaveItemBase(String name) {
        this(name, true);
    }

    protected WaveItemBase(boolean isParameter) {
        this(null, isParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaveItemBase(String name, boolean isParameter) {
        this.setParameter(isParameter);
        this.setName(name);
        Class<WaveItemBase> clazz = WaveItemBase.class;
        synchronized (WaveItemBase.class) {
            this.setUid(++idGenerator);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getUid() {
        return this.uid;
    }

    private void setUid(int uid) {
        this.uid = uid;
    }

    public Type getItemType() {
        return this.itemType;
    }

    public boolean equals(Object waveItem) {
        return waveItem instanceof WaveItemBase && this.getUid() == ((WaveItemBase)waveItem).getUid();
    }

    public int hashCode() {
        return this.getUid();
    }

    private void setName(String name) {
        this.name = name;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    public void setParameter(boolean isParameter) {
        this.isParameter = isParameter;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getItemType() != null) {
            if (this.getItemType() instanceof ParameterizedType) {
                sb.append(((ParameterizedType)this.getItemType()).toString());
            } else {
                sb.append(this.getItemType().toString());
            }
        }
        if (this.getName() != null) {
            sb.append(" ").append(this.getName());
        }
        return sb.toString();
    }

    public static void initEnum(WaveItemEnum waveItemEnum, WaveItemBase<?> wi) {
        super.setName(waveItemEnum.name());
    }
}

