/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.core.wave;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jrebirth.af.api.command.Command;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveItem;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.resource.provided.JRebirthParameters;
import org.jrebirth.af.core.util.ObjectUtility;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.core.wave.WaveTypeRegistry;

public final class WaveTypeBase
implements WaveType {
    private int uid;
    private String action;
    private final List<WaveItem<?>> waveItemList = new ArrayList();
    private String returnAction;
    private WaveItem<?> returnItem;
    private WaveType returnWaveType;
    private Class<? extends Command> returnCommandClass;
    private Map<Class<? extends Throwable>, Wave> waveExceptionHanler;

    WaveTypeBase() {
        this.uid(WaveTypeRegistry.getNextUid());
    }

    public int uid() {
        return this.uid;
    }

    public WaveTypeBase uid(int uid) {
        this.uid = uid;
        return this;
    }

    public String action() {
        return this.action;
    }

    public WaveTypeBase action(String action) {
        WaveTypeRegistry.store(action, this);
        this.action = action;
        return this;
    }

    public List<WaveItem<?>> items() {
        return this.waveItemList;
    }

    public WaveTypeBase items(WaveItem<?> ... items) {
        for (WaveItem<?> waveItem : items) {
            this.waveItemList.add(waveItem);
        }
        return this;
    }

    public String returnAction() {
        return this.returnAction;
    }

    public WaveTypeBase returnAction(String returnAction) {
        this.returnAction = returnAction;
        this.buildReturnWaveType();
        return this;
    }

    public WaveItem<?> returnItem() {
        return this.returnItem;
    }

    public WaveTypeBase returnItem(WaveItem<?> returnItem) {
        this.returnItem = returnItem;
        this.buildReturnWaveType();
        return this;
    }

    private void buildReturnWaveType() {
        if (this.returnAction != null && this.returnItem != null) {
            this.returnWaveType = Builders.waveType(this.returnAction).items(new WaveItem[]{this.returnItem()});
        }
    }

    public WaveType returnWaveType() {
        return this.returnWaveType;
    }

    public WaveType returnWaveType(WaveType returnWaveType) {
        this.returnWaveType = returnWaveType;
        this.returnAction = returnWaveType.action();
        this.returnItem = returnWaveType.items().stream().findFirst().orElse(null);
        return this;
    }

    public String getItems() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (WaveItem<?> waveItem : this.items()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String fullName = waveItem.getItemType() instanceof ParameterizedType ? ((ParameterizedType)waveItem.getItemType()).toString() : ((Class)waveItem.getItemType()).getName();
            sb.append(fullName).append(" ");
            fullName = fullName.replaceAll("[<>]", "");
            if (waveItem.getName() == null || waveItem.getName().isEmpty()) {
                sb.append(ObjectUtility.lowerFirstChar(fullName.substring(fullName.lastIndexOf(46) + 1)));
                continue;
            }
            sb.append(waveItem.getName());
        }
        return sb.toString();
    }

    public String toString() {
        return (String)JRebirthParameters.WAVE_HANDLER_PREFIX.get() + this.action;
    }

    public boolean equals(Object waveType) {
        return waveType instanceof WaveTypeBase && this.uid() == ((WaveTypeBase)waveType).uid();
    }

    public int hashCode() {
        return this.uid();
    }

    public Class<? extends Command> returnCommandClass() {
        return this.returnCommandClass;
    }

    public WaveType returnCommandClass(Class<? extends Command> returnCommandClass) {
        this.returnCommandClass = returnCommandClass;
        return this;
    }

    public List<WaveItem<?>> parameters() {
        return this.items().stream().filter(item -> item.isParameter()).collect(Collectors.toList());
    }

    public Map<Class<? extends Throwable>, Wave> waveExceptionHanler() {
        if (this.waveExceptionHanler == null) {
            this.waveExceptionHanler = new ConcurrentHashMap<Class<? extends Throwable>, Wave>();
        }
        return this.waveExceptionHanler;
    }

    public WaveType onException(Class<? extends Command> exceptionCommandClass, Class<? extends Throwable> ... exceptionTypes) {
        Wave commandWave = Builders.callCommand(exceptionCommandClass);
        for (Class<? extends Throwable> type : exceptionTypes) {
            this.waveExceptionHanler().put(type, commandWave);
        }
        return this;
    }

    public WaveType onException(WaveType exceptionWaveType, Class<? extends Throwable> ... exceptionTypes) {
        Wave wave = Builders.wave().waveType(exceptionWaveType);
        for (Class<? extends Throwable> type : exceptionTypes) {
            this.waveExceptionHanler().put(type, wave);
        }
        return this;
    }
}

