/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.preloader;

import javafx.animation.ScaleTransitionBuilder;
import javafx.application.Preloader;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jrebirth.af.preloader.MessageNotification;

public class JRebirthPreloader
extends Preloader {
    private ProgressBar progressBar;
    private Stage preloaderStage;
    private Text messageText;
    private boolean jrebirthInitialized = false;

    public void init() throws Exception {
        super.init();
    }

    public void start(Stage stage) throws Exception {
        this.preloaderStage = stage;
        stage.centerOnScreen();
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(this.createPreloaderScene());
        stage.show();
    }

    private Scene createPreloaderScene() {
        StackPane p = new StackPane();
        ImageView logo = new ImageView(new Image("JRebirth_Title.png"));
        p.getChildren().add((Object)logo);
        StackPane.setAlignment((Node)logo, (Pos)Pos.CENTER);
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setPrefSize(460.0, 20.0);
        p.getChildren().add((Object)this.progressBar);
        StackPane.setAlignment((Node)this.progressBar, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.progressBar, (Insets)new Insets(30.0));
        this.messageText = new Text("Loading");
        p.getChildren().add((Object)this.messageText);
        StackPane.setAlignment((Node)this.messageText, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.messageText, (Insets)new Insets(10.0));
        return new Scene((Parent)p, 600.0, 200.0, (Paint)Color.TRANSPARENT);
    }

    public void stop() throws Exception {
        super.stop();
    }

    public void handleProgressNotification(Preloader.ProgressNotification pn) {
        if (this.jrebirthInitialized && pn.getProgress() >= 0.0 && pn.getProgress() <= 1.0) {
            this.progressBar.setProgress(pn.getProgress());
        } else {
            this.messageText.setText(this.getMessageFromCode((int)pn.getProgress()));
        }
    }

    private String getMessageFromCode(int messageCode) {
        String res = "";
        switch (messageCode) {
            case 100: {
                res = "Initializing";
                break;
            }
            case 200: {
                res = "";
                break;
            }
            case 300: {
                res = "";
                break;
            }
            case 400: {
                res = "Loading Messages Properties";
                break;
            }
            case 500: {
                res = "Loading Parameters Properties";
                break;
            }
            case 600: {
                res = "Preparing Core Engine";
                break;
            }
            case 700: {
                res = "Preloading Resources";
                break;
            }
            case 800: {
                res = "Preloading Modules";
                break;
            }
            case 900: {
                res = "";
                break;
            }
            case 1000: {
                res = "Starting";
                break;
            }
        }
        return res;
    }

    public void handleApplicationNotification(Preloader.PreloaderNotification n) {
        if (n instanceof MessageNotification) {
            this.messageText.setText(((MessageNotification)n).getMessage());
        } else if (n instanceof Preloader.ProgressNotification) {
            this.handleProgressNotification((Preloader.ProgressNotification)n);
        }
    }

    public boolean handleErrorNotification(Preloader.ErrorNotification arg0) {
        return super.handleErrorNotification(arg0);
    }

    public void handleStateChangeNotification(Preloader.StateChangeNotification event) {
        switch (event.getType()) {
            case BEFORE_LOAD: {
                break;
            }
            case BEFORE_INIT: {
                this.jrebirthInitialized = true;
                break;
            }
            case BEFORE_START: {
                this.beforeStart();
                break;
            }
        }
    }

    private void beforeStart() {
        final Stage stage = this.preloaderStage;
        ((ScaleTransitionBuilder)ScaleTransitionBuilder.create().fromX(1.0).toX(0.0).duration(Duration.millis((double)400.0)).node((Node)stage.getScene().getRoot()).onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                stage.hide();
            }
        })).build().play();
    }
}

