/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.modular;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javafx.util.Pair;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jrebirth.af.modular.model.Component;
import org.jrebirth.af.modular.model.Module;
import org.jrebirth.af.modular.model.ObjectFactory;
import org.jrebirth.af.modular.model.Registration;
import org.jrebirth.af.modular.model.RegistrationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModuleConfigFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleConfigFileParser.class);

    private ModuleConfigFileParser() {
    }

    public static InputStream loadInputStream(String custConfFileName) {
        InputStream is = null;
        File resourceFile = new File(custConfFileName);
        if (resourceFile.exists()) {
            try {
                is = new FileInputStream(resourceFile);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(custConfFileName);
        }
        return is;
    }

    public static Module parseFile(String fileName) {
        Module module = null;
        File file = new File(fileName);
        ObjectFactory factory = new ObjectFactory();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jrebirth.af.modular.model", (ClassLoader)ObjectFactory.class.getClassLoader());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            InputStreamReader in = new InputStreamReader(ModuleConfigFileParser.loadInputStream(fileName), StandardCharsets.UTF_8);
            XMLStreamReader xsr = XMLInputFactory.newInstance().createXMLStreamReader(in);
            Object o = unmarshaller.unmarshal(xsr);
            if (o instanceof JAXBElement && ((JAXBElement)o).getValue() instanceof Module) {
                module = (Module)Module.class.cast(((JAXBElement)JAXBElement.class.cast(o)).getValue());
            }
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            LOGGER.error("An error occurred while parsing " + fileName, e);
        }
        return module;
    }

    public static List<Pair<Class<?>, Class<?>>> getRegistrations(String fileName) {
        Module module = ModuleConfigFileParser.parseFile(fileName);
        ArrayList pairList = new ArrayList();
        if (module != null && module.getRegistrations() != null) {
            for (Registration rl : module.getRegistrations().getRegistration()) {
                if (rl.getRegistrationEntries() == null) continue;
                for (RegistrationEntry re : rl.getRegistrationEntries().getRegistrationEntry()) {
                    try {
                        pairList.add(ModuleConfigFileParser.createPair(rl, re));
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error("Impossible to find a Component Class", (Throwable)e);
                    }
                }
            }
        }
        return pairList;
    }

    private static Pair<Class<?>, Class<?>> createPair(Registration rl, RegistrationEntry re) throws ClassNotFoundException {
        return new Pair(ModuleConfigFileParser.getClassObject(rl.getClazz()), ModuleConfigFileParser.getClassObject(re.getClazz()));
    }

    public static List<Class<?>> getWarmUp(String fileName) {
        Module module = ModuleConfigFileParser.parseFile(fileName);
        ArrayList warmUpList = new ArrayList();
        if (module != null && module.getWarmUp() != null) {
            for (Component component : module.getWarmUp().getComponent()) {
                if (component.getClazz() == null) continue;
                try {
                    warmUpList.add(ModuleConfigFileParser.getClassObject(component.getClazz()));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error("Impossible to find a Component Class", (Throwable)e);
                }
            }
        }
        return warmUpList;
    }

    private static Class<?> getClassObject(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }
}

