/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import org.jrebirth.af.api.resource.ResourceItem;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.WaveGroup;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.application.DefaultApplication;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.showcase.analyzer.service.LoadEdtFileService;
import org.jrebirth.af.showcase.analyzer.ui.editor.EditorWaves;
import org.jrebirth.af.showcase.analyzer.ui.workbench.WorkbenchModel;

public final class JRebirthAnalyzer
extends DefaultApplication<StackPane> {
    public static void main(String ... args) {
        Application.launch(JRebirthAnalyzer.class, (String[])args);
    }

    public Class<? extends Model> getFirstModelClass() {
        return WorkbenchModel.class;
    }

    protected String getApplicationTitle() {
        return "JavaFX 2.0 - JRebirth Event Analyzer";
    }

    protected void customizeScene(Scene scene) {
        scene.getStylesheets().add((Object)"css/analyzer.css");
    }

    protected void customizeStage(Stage stage) {
        stage.centerOnScreen();
    }

    public List<Wave> getPostBootWaveList() {
        String logFileName;
        File logFile;
        ArrayList<Wave> waveList = new ArrayList<Wave>();
        Application.Parameters p = this.getParameters();
        if (p.getRaw().size() >= 1 && (logFile = new File(logFileName = (String)p.getRaw().get(0))).exists()) {
            waveList.add(Builders.wave().waveGroup(WaveGroup.RETURN_DATA).waveType(LoadEdtFileService.DO_LOAD_EVENTS).componentClass(LoadEdtFileService.class).addDatas(new WaveData[]{Builders.waveData(EditorWaves.EVENTS_FILE, (Object)logFile)}));
            waveList.add(Builders.wave().waveType(EditorWaves.DO_PLAY));
        }
        return waveList;
    }

    protected List<? extends ResourceItem<?, ?, ?>> getResourceToPreload() {
        return Collections.emptyList();
    }
}

