/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer.command;

import org.jrebirth.af.api.facade.JRebirthEvent;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.command.single.internal.DefaultCommand;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.showcase.analyzer.command.AccessBallCommand;
import org.jrebirth.af.showcase.analyzer.command.CreateBallCommand;
import org.jrebirth.af.showcase.analyzer.command.DestroyBallCommand;
import org.jrebirth.af.showcase.analyzer.ui.editor.EditorWaves;

public final class ProcessEventCommand
extends DefaultCommand {
    public void perform(Wave wave) {
        JRebirthEvent event = (JRebirthEvent)wave.get(EditorWaves.EVENT);
        if (event.getEventType().name().startsWith("CREATE")) {
            this.createBallModel(event);
        } else if (event.getEventType().name().startsWith("ACCESS")) {
            this.accessBallModel(event);
        } else if (event.getEventType().name().startsWith("DESTROY")) {
            this.destroyBallModel(event);
        }
    }

    private void createBallModel(JRebirthEvent event) {
        switch (event.getEventType()) {
            case CREATE_APPLICATION: 
            case CREATE_NOTIFIER: 
            case CREATE_GLOBAL_FACADE: 
            case CREATE_COMMAND_FACADE: 
            case CREATE_SERVICE_FACADE: 
            case CREATE_UI_FACADE: 
            case CREATE_COMMAND: 
            case CREATE_SERVICE: 
            case CREATE_MODEL: 
            case CREATE_VIEW: 
            case CREATE_CONTROLLER: {
                this.callCommand(CreateBallCommand.class, new WaveData[]{Builders.waveData(EditorWaves.EVENT, (Object)event)});
                break;
            }
        }
    }

    private void accessBallModel(JRebirthEvent event) {
        switch (event.getEventType()) {
            case ACCESS_COMMAND: 
            case ACCESS_CONTROLLER: 
            case ACCESS_MODEL: 
            case ACCESS_SERVICE: 
            case ACCESS_VIEW: {
                this.callCommand(AccessBallCommand.class, new WaveData[]{Builders.waveData(EditorWaves.EVENT, (Object)event)});
                break;
            }
        }
    }

    private void destroyBallModel(JRebirthEvent event) {
        switch (event.getEventType()) {
            case DESTROY_COMMAND: 
            case DESTROY_SERVICE: 
            case DESTROY_MODEL: 
            case DESTROY_VIEW: 
            case DESTROY_CONTROLLER: {
                this.callCommand(DestroyBallCommand.class, new WaveData[]{Builders.waveData(EditorWaves.EVENT, (Object)event)});
                break;
            }
        }
    }
}

