/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jrebirth.af.api.concurrent.Priority;
import org.jrebirth.af.api.concurrent.RunnablePriority;
import org.jrebirth.af.api.facade.JRebirthEvent;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.facade.JRebirthEventBase;
import org.jrebirth.af.core.log.JRebirthMarkers;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.core.service.ServiceUtility;
import org.jrebirth.af.showcase.analyzer.service.LoadEdtFileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadEdtFileServiceImpl
extends DefaultService
implements LoadEdtFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadEdtFileServiceImpl.class);

    public void initService() {
        this.listen(new WaveType[]{DO_LOAD_EVENTS});
    }

    @Override
    @Priority(value=RunnablePriority.High)
    public List<JRebirthEvent> doLoadEvents(File selecteFile, Wave wave) {
        ArrayList<JRebirthEvent> eventList = new ArrayList<JRebirthEvent>();
        this.updateMessage(wave, "Parsing events");
        int totalLines = ServiceUtility.countFileLines((File)selecteFile);
        try (BufferedReader br = new BufferedReader(new FileReader(selecteFile));){
            int processedLines = 0;
            String strLine = br.readLine();
            while (strLine != null) {
                this.updateProgress(wave, ++processedLines, totalLines);
                if (strLine.contains(JRebirthMarkers.JREVENT.getName())) {
                    this.addEvent(eventList, strLine.substring(strLine.indexOf(">>") + 2));
                }
                strLine = br.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while processing event file", (Throwable)e);
        }
        return eventList;
    }

    private void addEvent(List<JRebirthEvent> eventList, String strLine) {
        eventList.add((JRebirthEvent)new JRebirthEventBase(strLine));
    }
}

