/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer.ui.controls;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.core.ui.DefaultView;
import org.jrebirth.af.showcase.analyzer.ui.controls.ControlsController;
import org.jrebirth.af.showcase.analyzer.ui.controls.ControlsModel;

public final class ControlsView
extends DefaultView<ControlsModel, HBox, ControlsController> {
    private Button openButton;
    private Button unloadButton;
    private Button playPauseButton;
    private Button backwardButton;
    private Button forwardButton;
    private Button stopButton;

    public ControlsView(ControlsModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        this.openButton = new Button("Open");
        HBox.setHgrow((Node)this.openButton, (Priority)Priority.ALWAYS);
        this.openButton.setMaxWidth(Double.MAX_VALUE);
        this.unloadButton = new Button("Unload");
        this.unloadButton.setDisable(true);
        HBox.setHgrow((Node)this.unloadButton, (Priority)Priority.ALWAYS);
        this.unloadButton.setMaxWidth(Double.MAX_VALUE);
        this.playPauseButton = new Button("Play");
        this.playPauseButton.setDisable(true);
        HBox.setHgrow((Node)this.playPauseButton, (Priority)Priority.ALWAYS);
        this.playPauseButton.setMaxWidth(Double.MAX_VALUE);
        this.backwardButton = new Button("<<");
        this.backwardButton.setDisable(true);
        HBox.setHgrow((Node)this.backwardButton, (Priority)Priority.ALWAYS);
        this.backwardButton.setMaxWidth(Double.MAX_VALUE);
        this.forwardButton = new Button(">>");
        this.forwardButton.setDisable(true);
        HBox.setHgrow((Node)this.forwardButton, (Priority)Priority.ALWAYS);
        this.forwardButton.setMaxWidth(Double.MAX_VALUE);
        this.stopButton = new Button("Stop");
        this.stopButton.setDisable(true);
        HBox.setHgrow((Node)this.stopButton, (Priority)Priority.ALWAYS);
        this.stopButton.setMaxWidth(Double.MAX_VALUE);
        ((HBox)this.getRootNode()).getChildren().addAll((Object[])new Node[]{this.openButton, this.unloadButton, this.playPauseButton, this.backwardButton, this.forwardButton, this.stopButton});
    }

    void activateButtons(boolean enable) {
        this.unloadButton.setDisable(!enable);
        this.playPauseButton.setDisable(!enable);
        this.backwardButton.setDisable(!enable);
        this.forwardButton.setDisable(!enable);
        this.stopButton.setDisable(!enable);
    }

    Button getOpenButton() {
        return this.openButton;
    }

    Button getUnloadButton() {
        return this.unloadButton;
    }

    Button getPlayPauseButton() {
        return this.playPauseButton;
    }

    Button getBackwardButton() {
        return this.backwardButton;
    }

    Button getForwardButton() {
        return this.forwardButton;
    }

    Button getStopButton() {
        return this.stopButton;
    }
}

