/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrebirth.af.api.facade.JRebirthEvent;
import org.jrebirth.af.api.wave.Wave;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.api.wave.contract.WaveType;
import org.jrebirth.af.core.ui.DefaultModel;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.showcase.analyzer.command.ProcessEventCommand;
import org.jrebirth.af.showcase.analyzer.service.LoadEdtFileService;
import org.jrebirth.af.showcase.analyzer.ui.editor.EditorView;
import org.jrebirth.af.showcase.analyzer.ui.editor.EditorWaves;
import org.jrebirth.af.showcase.analyzer.ui.editor.ball.BallModel;

public final class EditorModel
extends DefaultModel<EditorModel, EditorView> {
    private int timeFrame = -1;
    private final Map<String, BallModel> ballMap = new HashMap<String, BallModel>();
    private List<JRebirthEvent> eventList;
    private boolean playing;

    protected void initModel() {
        this.listen(new WaveType[]{LoadEdtFileService.DO_LOAD_EVENTS.returnWaveType()});
        this.listen(new WaveType[]{EditorWaves.DO_UNLOAD});
        this.listen(new WaveType[]{EditorWaves.DO_PLAY});
        this.listen(new WaveType[]{EditorWaves.DO_NEXT});
        this.listen(new WaveType[]{EditorWaves.DO_PREVIOUS});
        this.listen(new WaveType[]{EditorWaves.DO_STOP});
        this.listen(new WaveType[]{EditorWaves.RE_EVENT_PROCESSED});
    }

    public void doEventsLoaded(List<JRebirthEvent> eventList, Wave wave) {
        this.eventList = eventList;
    }

    public void doUnload(Wave wave) {
        this.eventList = new ArrayList<JRebirthEvent>();
        ArrayList<BallModel> list = new ArrayList<BallModel>(this.ballMap.values());
        for (BallModel ballModel : list) {
            this.unregisterBall(ballModel);
        }
    }

    public void doPlay(Wave wave) {
        if (!this.playing) {
            this.playing = true;
            this.timeFrame = 0;
        }
        if (this.timeFrame < this.eventList.size() - 1) {
            this.showNext(this.eventList.get(this.timeFrame));
        } else {
            this.playing = false;
        }
    }

    public void doEventProcessed(Wave wave) {
        if (this.playing) {
            this.doPlay(wave);
        }
    }

    public void doNext(Wave wave) {
        if (this.eventList != null && this.timeFrame + 1 < this.eventList.size()) {
            this.showNext(this.eventList.get(this.timeFrame + 1));
        }
    }

    private void showNext(JRebirthEvent event) {
        ++this.timeFrame;
        this.callCommand(ProcessEventCommand.class, new WaveData[]{Builders.waveData(EditorWaves.EVENT, (Object)event)});
    }

    public void doPrevious(Wave wave) {
        if (this.eventList != null && this.timeFrame > 0) {
            this.hideCurrent(this.eventList.get(this.timeFrame));
        }
    }

    private void hideCurrent(JRebirthEvent event) {
        --this.timeFrame;
        ((BallModel)this.getModel(BallModel.class, new Object[]{event})).hide();
    }

    public void doStop(Wave wave) {
        for (int i = this.timeFrame; i >= 0; --i) {
            this.hideCurrent(this.eventList.get(this.timeFrame));
        }
    }

    public List<JRebirthEvent> getEventList() {
        return this.eventList;
    }

    public void registerBall(BallModel ballModel) {
        if (!this.ballMap.containsKey(ballModel.getEventModel().getTarget())) {
            this.ballMap.put(ballModel.getEventModel().getTarget(), ballModel);
            ((EditorView)this.getView()).getPanel().getChildren().add((Object)ballModel.getRootNode());
        }
    }

    public void unregisterBall(BallModel ballModel) {
        this.ballMap.remove(ballModel.getEventModel().getTarget());
        ((EditorView)this.getView()).getPanel().getChildren().remove((Object)ballModel.getRootNode());
    }

    public BallModel retrieveBall(String source) {
        return this.ballMap.get(source);
    }
}

