/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.showcase.analyzer.ui.editor.ball;

import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.ScaleTransition;
import javafx.animation.ScaleTransitionBuilder;
import javafx.animation.TranslateTransitionBuilder;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadowBuilder;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadowBuilder;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;
import javafx.util.Duration;
import org.jrebirth.af.api.exception.CoreException;
import org.jrebirth.af.api.facade.JRebirthEventType;
import org.jrebirth.af.api.ui.Model;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.ui.DefaultView;
import org.jrebirth.af.showcase.analyzer.ui.editor.BallColors;
import org.jrebirth.af.showcase.analyzer.ui.editor.EditorWaves;
import org.jrebirth.af.showcase.analyzer.ui.editor.ball.BallController;
import org.jrebirth.af.showcase.analyzer.ui.editor.ball.BallModel;

public final class BallView
extends DefaultView<BallModel, StackPane, BallController> {
    private ScaleTransition scaleTransition;
    private ParallelTransition showTransition;
    private Circle circle;
    private Label label;

    public BallView(BallModel model) throws CoreException {
        super((Model)model);
    }

    protected void initView() {
        ((StackPane)this.getRootNode()).setScaleX(0.0);
        ((StackPane)this.getRootNode()).setScaleY(0.0);
        this.circle = ((CircleBuilder)((CircleBuilder)((CircleBuilder)CircleBuilder.create().radius(22.0).fill((Paint)Color.ALICEBLUE)).stroke((Paint)Color.WHITE)).strokeWidth(4.0)).build();
        this.label = ((LabelBuilder)LabelBuilder.create().textFill((Paint)Color.WHITE)).build();
        ((StackPane)this.getRootNode()).getChildren().addAll((Object[])new Node[]{this.circle, this.label});
        this.showTransition = ((ParallelTransitionBuilder)((ParallelTransitionBuilder)ParallelTransitionBuilder.create().children(new Animation[]{ScaleTransitionBuilder.create().duration(Duration.millis((double)400.0)).node(this.getRootNode()).fromX(0.0).fromY(0.0).toX(1.0).toY(1.0).build(), TranslateTransitionBuilder.create().duration(Duration.millis((double)500.0)).node(this.getRootNode()).fromX(0.0).fromY(0.0).toX(this.getX()).toY(this.getY()).build()}).cycleCount(1)).autoReverse(false)).build();
        this.showTransition.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                ((BallModel)BallView.this.getModel()).sendWave(EditorWaves.RE_EVENT_PROCESSED, new WaveData[0]);
            }
        });
        this.scaleTransition = ((ScaleTransitionBuilder)((ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(Duration.millis((double)600.0)).node(this.getRootNode()).fromX(1.1).fromY(1.1).toX(0.7).toY(0.7).cycleCount(-1)).autoReverse(true)).build();
        this.circle.setEffect((Effect)InnerShadowBuilder.create().color(Color.GREY).blurType(BlurType.GAUSSIAN).radius(2.0).offsetX(1.0).offsetY(1.0).build());
        ((StackPane)this.getRootNode()).setEffect((Effect)DropShadowBuilder.create().color(Color.BLACK).blurType(BlurType.GAUSSIAN).radius(4.0).offsetX(3.0).offsetY(3.0).build());
    }

    ScaleTransition getScaleTransition() {
        return this.scaleTransition;
    }

    public void setStyle(JRebirthEventType eventType) {
        switch (eventType) {
            case CREATE_APPLICATION: {
                this.circle.setFill((Paint)BallColors.APPLICATION.get());
                this.label.setText("App");
                break;
            }
            case CREATE_NOTIFIER: {
                this.circle.setFill((Paint)BallColors.NOTIFIER.get());
                this.label.setText("N");
                break;
            }
            case CREATE_GLOBAL_FACADE: {
                this.circle.setFill((Paint)BallColors.GLOBAL_FACADE.get());
                this.label.setText("GF");
                break;
            }
            case CREATE_UI_FACADE: {
                this.circle.setFill((Paint)BallColors.UI_FACADE.get());
                this.label.setText("UF");
                break;
            }
            case CREATE_SERVICE_FACADE: {
                this.circle.setFill((Paint)BallColors.SERVICE_FACADE.get());
                this.label.setText("SF");
                break;
            }
            case CREATE_COMMAND_FACADE: {
                this.circle.setFill((Paint)BallColors.COMMAND_FACADE.get());
                this.label.setText("CF");
                break;
            }
            case CREATE_SERVICE: {
                this.circle.setFill((Paint)BallColors.SERVICE.get());
                this.label.setText("S");
                break;
            }
            case CREATE_MODEL: {
                this.circle.setFill((Paint)BallColors.MODEL.get());
                this.label.setText("M");
                break;
            }
            case CREATE_COMMAND: {
                this.circle.setFill((Paint)BallColors.COMMAND.get());
                this.label.setText("C");
                break;
            }
            case CREATE_VIEW: {
                this.circle.setFill((Paint)BallColors.VIEW.get());
                this.label.setText("V");
                break;
            }
        }
    }

    public void resetScale() {
        ((ScaleTransitionBuilder)((ScaleTransitionBuilder)ScaleTransitionBuilder.create().duration(Duration.millis((double)400.0)).node(this.getRootNode()).toX(1.0).toY(1.0).cycleCount(1)).autoReverse(false)).build().play();
    }

    public void start() {
        this.showTransition.play();
    }

    public void hide() {
        this.showTransition.setRate(-1.0);
        this.showTransition.play();
    }

    ParallelTransition getShowTransition() {
        return this.showTransition;
    }

    private double getX() {
        double res;
        switch (((BallModel)this.getModel()).getEventModel().getEventType()) {
            case CREATE_APPLICATION: 
            case CREATE_COMMAND_FACADE: 
            case CREATE_COMMAND: {
                res = 0.0;
                break;
            }
            case CREATE_NOTIFIER: 
            case CREATE_GLOBAL_FACADE: {
                res = 70.0;
                break;
            }
            case CREATE_SERVICE_FACADE: 
            case CREATE_SERVICE: {
                res = -200.0 * Math.cos(0.5235987755982988);
                break;
            }
            case CREATE_UI_FACADE: 
            case CREATE_MODEL: {
                res = 200.0 * Math.cos(0.5235987755982988);
                break;
            }
            default: {
                res = 50.0;
            }
        }
        return res;
    }

    private double getY() {
        double res;
        switch (((BallModel)this.getModel()).getEventModel().getEventType()) {
            case CREATE_COMMAND_FACADE: 
            case CREATE_COMMAND: {
                res = -200.0 * Math.sin(1.5707963267948966);
                break;
            }
            case CREATE_APPLICATION: 
            case CREATE_NOTIFIER: 
            case CREATE_GLOBAL_FACADE: {
                res = 0.0;
                break;
            }
            case CREATE_UI_FACADE: 
            case CREATE_SERVICE_FACADE: 
            case CREATE_SERVICE: 
            case CREATE_MODEL: {
                res = 200.0 * Math.sin(0.5235987755982988);
                break;
            }
            default: {
                res = 50.0;
            }
        }
        return res;
    }
}

