/*
 * Decompiled with CFR 0.152.
 */
package org.jrebirth.af.undoredo.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jrebirth.af.api.wave.contract.WaveData;
import org.jrebirth.af.core.service.DefaultService;
import org.jrebirth.af.core.wave.Builders;
import org.jrebirth.af.undoredo.command.UndoRedoWaves;
import org.jrebirth.af.undoredo.command.Undoable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoRedoService
extends DefaultService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoRedoService.class);
    private final List<Undoable> commandStack = Collections.synchronizedList(new ArrayList());
    private final List<Undoable> undoneStack = Collections.synchronizedList(new ArrayList());

    public void stackUp(Undoable command) {
        this.commandStack.add(command);
        this.commandStack.get(this.commandStack.size() - 1).run(Builders.wave().addDatas(new WaveData[]{Builders.waveData(UndoRedoWaves.UNDO_REDO, (Object)false)}));
    }

    public void undo() {
        if (this.commandStack.size() > 0) {
            this.undoneStack.add(this.commandStack.get(this.commandStack.size() - 1));
            this.commandStack.remove(this.commandStack.get(this.commandStack.size() - 1));
            this.undoneStack.get(this.undoneStack.size() - 1).run(Builders.wave().addDatas(new WaveData[]{Builders.waveData(UndoRedoWaves.UNDO_REDO, (Object)true)}));
        } else {
            LOGGER.info("No more command to undo, begin of stack");
        }
    }

    public void redo() {
        if (this.undoneStack.size() > 0) {
            this.commandStack.add(this.undoneStack.get(this.undoneStack.size() - 1));
            this.undoneStack.remove(this.undoneStack.size() - 1);
            this.commandStack.get(this.commandStack.size() - 1).run(Builders.wave().addDatas(new WaveData[]{Builders.waveData(UndoRedoWaves.UNDO_REDO, (Object)false)}));
        } else {
            LOGGER.info("No more command to redo, end of stack");
        }
    }
}

