/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.base.domain;

import com.google.common.base.MoreObjects;
import javax.persistence.Column;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import org.jresearch.commons.base.domain.DomainJpa;
import org.jresearch.commons.base.domain.ref.BusinessType;

@MappedSuperclass
public abstract class AttributeValue
extends DomainJpa {
    @Column(name="ATTR_VALUE_STR")
    private String valueStr;
    @Column(name="ATTR_VALUE_INT")
    private Integer valueInt;
    @Column(name="ATTR_VALUE_DOUBLE")
    private Double valueDouble;
    private String externalRef;
    @ManyToOne
    private BusinessType businessType;

    public String getValueStr() {
        return this.valueStr;
    }

    public void setValueStr(String valueStr) {
        this.valueStr = valueStr;
    }

    public Integer getValueInt() {
        return this.valueInt;
    }

    public void setValueInt(Integer valueInt) {
        this.valueInt = valueInt;
    }

    public Double getValueDouble() {
        return this.valueDouble;
    }

    public void setValueDouble(Double valueDouble) {
        this.valueDouble = valueDouble;
    }

    public BusinessType getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(BusinessType businessType) {
        this.businessType = businessType;
    }

    public static void setTypedValue(AttributeValue attr) {
        BusinessType type = attr.getBusinessType();
        String valueStr = attr.getValueStr();
        if (type != null && valueStr != null) {
            String paramCode;
            if (type.getParameterType() == null) {
                throw new IllegalArgumentException("ParameterType is not set for BusinessType");
            }
            if (type.getParameterType().getCode() == null) {
                throw new IllegalArgumentException("ParameterType code is not set for ParamType");
            }
            switch (paramCode = type.getParameterType().getCode()) {
                case "S": {
                    attr.setValueStr(valueStr);
                    break;
                }
                case "F": {
                    attr.setValueDouble(Double.valueOf(valueStr));
                    break;
                }
                case "L": 
                case "C": {
                    attr.setValueInt(Integer.valueOf(valueStr));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This parameter type is currently unsupported for custom attributes");
                }
            }
        }
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("super", (Object)super.toString()).add("valueStr", (Object)this.valueStr).add("valueInt", (Object)this.valueInt).add("valueDouble", (Object)this.valueDouble).add("externalRef", (Object)this.externalRef).add("businessType", (Object)this.businessType).toString();
    }
}

