/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.commons.base.domain.ref;

import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Type;
import org.jresearch.commons.base.domain.ref.BaseReferenceJpa;
import org.jresearch.commons.base.domain.ref.ParamType;
import org.jresearch.commons.base.domain.ref.ValidValue;
import org.jresearch.commons.base.localization.domain.Localized;

@Entity
public class BusinessType
extends BaseReferenceJpa {
    @Column(unique=true, nullable=false)
    private String code;
    @Type(type="org.jresearch.commons.base.resources.impl.LocalizedType")
    private Localized description;
    @ManyToOne(optional=false)
    @JoinColumn(name="PARAMTYPE", nullable=false)
    private ParamType parameterType;
    @Column(name="IS_MANDATORY")
    private Boolean mandatory;
    private Long minValue;
    private Long maxValue;
    private String regularExpression;
    @OneToMany(mappedBy="businessType")
    private Set<ValidValue> values = new HashSet<ValidValue>();
    @Column(name="IS_USER_ATTRIBUTE")
    private Boolean userAttribute;
    @Column(unique=true)
    private String externalRef;

    public void addValidValue(ValidValue v) {
        this.values.add(v);
    }

    public void removeValidValue(ValidValue v) {
        this.values.remove(v);
    }

    public Localized getDescription() {
        return this.description;
    }

    public void setDescription(Localized description) {
        this.description = description;
    }

    public ParamType getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(ParamType parameterType) {
        this.parameterType = parameterType;
    }

    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public Long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Long minValue) {
        this.minValue = minValue;
    }

    public Long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Long maxValue) {
        this.maxValue = maxValue;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String regularExpression) {
        this.regularExpression = regularExpression;
    }

    public Set<ValidValue> getValues() {
        return this.values;
    }

    public void setValues(Set<ValidValue> values) {
        this.values = values;
    }

    public Boolean getUserAttribute() {
        return this.userAttribute;
    }

    public void setUserAttribute(Boolean userAttribute) {
        this.userAttribute = userAttribute;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("super", (Object)super.toString()).add("code", (Object)this.code).add("description", (Object)this.description).add("parameterType", (Object)this.parameterType).add("mandatory", (Object)this.mandatory).add("minValue", (Object)this.minValue).add("maxValue", (Object)this.maxValue).add("regularExpression", (Object)this.regularExpression).add("values", this.values).add("userAttribute", (Object)this.userAttribute).add("externalRef", (Object)this.externalRef).toString();
    }
}

